/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.proxy.extractor;

import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.util.proxy.extractor.ProxyExtractor;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.HibernateProxyHelper;

public class HibernateProxyExtractor
implements ProxyExtractor {
    private boolean initializePorxy;

    public void configure(CompassSettings settings) throws CompassException {
        this.initializePorxy = settings.getSettingAsBoolean("compass.marshalling.hibernate.initializeProxy", true);
    }

    public Class getTargetClass(Object obj) {
        if (obj instanceof HibernateProxy) {
            return HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
        }
        return obj.getClass();
    }

    public void initalizeProxy(Object obj) {
        if (this.initializePorxy) {
            Hibernate.initialize((Object)obj);
        }
    }
}

