/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.proxy.extractor;

import java.util.ArrayList;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.proxy.extractor.HibernateProxyExtractor;
import org.compass.core.util.proxy.extractor.ProxyExtractor;
import org.compass.core.util.proxy.extractor.SpringProxyExtractor;

public class ProxyExtractorHelper
implements CompassConfigurable {
    private ProxyExtractor[] extractors;

    public void configure(CompassSettings settings) throws CompassException {
        ProxyExtractor extractor;
        ArrayList<ProxyExtractor> extractorsList = new ArrayList<ProxyExtractor>();
        try {
            ClassUtils.forName("org.springframework.aop.support.AopUtils", settings.getClassLoader());
            extractor = new SpringProxyExtractor();
            extractor.configure(settings);
            extractorsList.add(extractor);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            ClassUtils.forName("org.hibernate.proxy.HibernateProxyHelper", settings.getClassLoader());
            extractor = new HibernateProxyExtractor();
            extractor.configure(settings);
            extractorsList.add(extractor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.extractors = extractorsList.toArray(new ProxyExtractor[extractorsList.size()]);
    }

    public Class getTargetClass(Object obj) {
        Class<?> objClass = obj.getClass();
        for (ProxyExtractor extractor : this.extractors) {
            Class clazz = extractor.getTargetClass(obj);
            if (clazz.equals(objClass)) continue;
            return clazz;
        }
        return objClass;
    }

    public void initializeProxy(Object obj) {
        for (ProxyExtractor extractor : this.extractors) {
            extractor.initalizeProxy(obj);
        }
    }
}

