/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.reflection.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.compass.core.util.asm.ClassVisitor;
import org.compass.core.util.asm.ClassWriter;
import org.compass.core.util.asm.MethodVisitor;
import org.compass.core.util.asm.Type;
import org.compass.core.util.reflection.ReflectionField;
import org.compass.core.util.reflection.plain.PlainReflectionField;

public class AsmReflectionFieldGenerator {
    private static final String PLAIN_FIELD_INTERNAL_NAME = Type.getInternalName(PlainReflectionField.class);

    public static synchronized ReflectionField generateField(Field refField) throws NoSuchFieldException {
        int methodIndex;
        Class<?> declaringClass = refField.getDeclaringClass();
        String ownerClassName = declaringClass.getName();
        Field[] declaredFields = declaringClass.getDeclaredFields();
        for (methodIndex = 0; methodIndex < declaredFields.length && !declaredFields[methodIndex].equals(refField); ++methodIndex) {
        }
        String className = ownerClassName + "FieldReflection" + methodIndex;
        try {
            Class definedClass;
            try {
                definedClass = declaringClass.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                String classInternalName = className.replace('.', '/');
                ClassWriter cw = new ClassWriter(1);
                cw.visit(48, 33, classInternalName, null, PLAIN_FIELD_INTERNAL_NAME, null);
                AsmReflectionFieldGenerator.createConstructor(cw);
                AsmReflectionFieldGenerator.createGetMethod(cw, declaringClass, refField);
                AsmReflectionFieldGenerator.createSetMethod(cw, declaringClass, refField);
                cw.visitEnd();
                byte[] b = cw.toByteArray();
                definedClass = AsmReflectionFieldGenerator.defineClass(refField.getDeclaringClass().getClassLoader(), className, b);
            }
            Constructor<?> ctor = definedClass.getConstructor(Field.class);
            return (ReflectionField)ctor.newInstance(refField);
        }
        catch (Exception e) {
            NoSuchFieldException err = new NoSuchFieldException("Can't create ASM field reflection helper for [" + refField + "]");
            err.initCause(e);
            throw err;
        }
    }

    private static void createConstructor(ClassVisitor cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/reflect/Field;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(PlainReflectionField.class), "<init>", "(Ljava/lang/reflect/Field;)V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void createGetMethod(ClassVisitor cw, Class entryClass, Field field) {
        MethodVisitor mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/IllegalArgumentException", "java/lang/IllegalAccessException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(entryClass));
        mv.visitFieldInsn(180, Type.getInternalName(entryClass), field.getName(), Type.getDescriptor(field.getType()));
        AsmReflectionFieldGenerator.boxIfNeeded(mv, field);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
    }

    private static void createSetMethod(ClassVisitor cw, Class entryClass, Field field) {
        MethodVisitor mv = cw.visitMethod(1, "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, new String[]{"java/lang/IllegalArgumentException", "java/lang/IllegalAccessException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(entryClass));
        mv.visitVarInsn(25, 2);
        AsmReflectionFieldGenerator.castAndUnboxIfNeeded(mv, field);
        mv.visitFieldInsn(181, Type.getInternalName(entryClass), field.getName(), Type.getDescriptor(field.getType()));
        mv.visitInsn(177);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
    }

    private static void castAndUnboxIfNeeded(MethodVisitor mv, Field field) {
        if (!field.getType().isPrimitive()) {
            mv.visitTypeInsn(192, Type.getInternalName(field.getType()));
            return;
        }
        Type type = Type.getType(field.getType());
        switch (type.getSort()) {
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Integer");
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Short");
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Float");
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Double");
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Byte");
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            }
        }
    }

    private static void boxIfNeeded(MethodVisitor mv, Field field) {
        if (!field.getType().isPrimitive()) {
            return;
        }
        Type type = Type.getType(field.getType());
        switch (type.getSort()) {
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            }
        }
    }

    private static Class defineClass(ClassLoader loader, String name, byte[] b) throws Exception {
        Method defineMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        defineMethod.setAccessible(true);
        return (Class)defineMethod.invoke((Object)loader, name, b, 0, b.length);
    }
}

