/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.embedded.hibernate;

import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.compass.core.Compass;
import org.compass.core.CompassTemplate;
import org.compass.gps.device.hibernate.embedded.HibernateHelper;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.embedded.DefaultJpaCompassGps;
import org.compass.gps.device.jpa.embedded.JpaCompassGps;
import org.compass.gps.device.jpa.support.NativeJpaHelper;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.ejb.HibernateEntityManagerFactory;

public abstract class HibernateJpaHelper {
    public static Compass getCompass(EntityManagerFactory emf) {
        EntityManagerFactory nativeEmf = NativeJpaHelper.extractNativeJpa(emf);
        return HibernateHelper.getCompass(((HibernateEntityManagerFactory)nativeEmf).getSessionFactory());
    }

    public static CompassTemplate getCompassTemplate(EntityManagerFactory emf) {
        EntityManagerFactory nativeEmf = NativeJpaHelper.extractNativeJpa(emf);
        return HibernateHelper.getCompassTempalte(((HibernateEntityManagerFactory)nativeEmf).getSessionFactory());
    }

    public static Compass getCompass(EntityManager em) {
        EntityManager nativeEm = NativeJpaHelper.extractNativeJpa(em);
        return HibernateHelper.getCompass(((HibernateEntityManager)nativeEm).getSession());
    }

    public static CompassTemplate getCompassTemplate(EntityManager em) {
        EntityManager nativeEm = NativeJpaHelper.extractNativeJpa(em);
        return HibernateHelper.getCompassTempalte(((HibernateEntityManager)nativeEm).getSession());
    }

    public static Properties getIndexSettings(EntityManagerFactory emf) {
        EntityManagerFactory nativeEmf = NativeJpaHelper.extractNativeJpa(emf);
        return HibernateHelper.getIndexSettings(((HibernateEntityManagerFactory)nativeEmf).getSessionFactory());
    }

    public static Properties getIndexSettings(EntityManager em) {
        EntityManager nativeEm = NativeJpaHelper.extractNativeJpa(em);
        return HibernateHelper.getIndexSettings(((HibernateEntityManager)nativeEm).getSession());
    }

    public static JpaCompassGps getCompassGps(EntityManagerFactory emf) {
        JpaGpsDevice device = new JpaGpsDevice("jpadevice", emf);
        return HibernateJpaHelper.getCompassGps(device);
    }

    public static JpaCompassGps getCompassGps(JpaGpsDevice device) {
        DefaultJpaCompassGps gps = new DefaultJpaCompassGps(HibernateJpaHelper.getCompass(device.getEntityManagerFactory()));
        device.setMirrorDataChanges(false);
        gps.setIndexProperties(HibernateJpaHelper.getIndexSettings(device.getEntityManagerFactory()));
        gps.addGpsDevice(device);
        gps.start();
        return gps;
    }

    private HibernateJpaHelper() {
    }
}

