/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.impl;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.core.util.ClassUtils;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.CompassGpsException;
import org.compass.gps.DefaultIndexPlan;
import org.compass.gps.IndexPlan;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public abstract class AbstractCompassGps
implements CompassGpsInterfaceDevice {
    protected Log log = LogFactory.getLog(this.getClass());
    protected HashMap<String, CompassGpsDevice> devices = new HashMap();
    private volatile boolean started = false;
    private volatile boolean performingIndexOperation = false;

    public void addGpsDevice(CompassGpsDevice gpsDevice) {
        this.checkDeviceValidity(gpsDevice);
        gpsDevice.injectGps(this);
        this.devices.put(gpsDevice.getName(), gpsDevice);
    }

    public void setGpsDevices(CompassGpsDevice[] devices) {
        this.devices.clear();
        for (CompassGpsDevice device : devices) {
            this.checkDeviceValidity(device);
            device.injectGps(this);
            this.devices.put(device.getName(), device);
        }
    }

    protected CompassGpsDevice getGpsDevice(String name) {
        return this.devices.get(name);
    }

    private void checkDeviceValidity(CompassGpsDevice device) {
        if (device.getName() == null) {
            throw new IllegalArgumentException("Must specify a name for a gps device");
        }
        if (this.devices.get(device.getName()) != null) {
            throw new IllegalArgumentException("A gps device with the name [" + device.getName() + "] is defined twice. It is not allowed.");
        }
    }

    protected boolean hasRootMappingForEntity(Class clazz, Compass checkedCompass) {
        return this.getRootMappingForEntity(clazz, checkedCompass) != null;
    }

    protected boolean hasMappingForEntity(Class clazz, Compass checkedCompass, CascadeMapping.Cascade cascade) {
        return ((InternalCompass)checkedCompass).getMapping().hasMappingForClass(clazz, cascade);
    }

    protected boolean hasMappingForEntity(String name, Compass checkedCompass, CascadeMapping.Cascade cascade) {
        return ((InternalCompass)checkedCompass).getMapping().hasMappingForAlias(name, cascade);
    }

    protected ResourceMapping getRootMappingForEntity(Class clazz, Compass checkedCompass) {
        return ((InternalCompass)checkedCompass).getMapping().getRootMappingByClass(clazz);
    }

    protected boolean hasRootMappingForEntity(String name, Compass checkedCompass) {
        return this.getRootMappingForEntity(name, checkedCompass) != null;
    }

    protected ResourceMapping getMappingForEntity(String name, Compass checkedCompass) {
        ResourceMapping resourceMapping = ((InternalCompass)checkedCompass).getMapping().getMappingByAlias(name);
        if (resourceMapping != null) {
            return resourceMapping;
        }
        try {
            Class clazz = ClassUtils.forName(name, checkedCompass.getSettings().getClassLoader());
            return ((InternalCompass)checkedCompass).getMapping().getMappingByClass(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ResourceMapping getRootMappingForEntity(String name, Compass checkedCompass) {
        ResourceMapping resourceMapping = ((InternalCompass)checkedCompass).getMapping().getRootMappingByAlias(name);
        if (resourceMapping != null) {
            return resourceMapping;
        }
        try {
            Class clazz = ClassUtils.forName(name, checkedCompass.getSettings().getClassLoader());
            return ((InternalCompass)checkedCompass).getMapping().getRootMappingByClass(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized void index() throws CompassGpsException, IllegalStateException {
        this.index(new DefaultIndexPlan());
    }

    public void index(Class ... types) throws CompassGpsException, IllegalStateException {
        this.index(new DefaultIndexPlan().setTypes(types));
    }

    public void index(String ... aliases) throws CompassGpsException, IllegalStateException {
        this.index(new DefaultIndexPlan().setAliases(aliases));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void index(IndexPlan indexPlan) throws CompassGpsException, IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException("CompassGps must be running in order to perform the index operation");
        }
        if (((InternalCompass)this.getMirrorCompass()).getTransactionFactory().getTransactionBoundSession() != null) {
            throw new CompassGpsException("index() operation is not allowed to be called within a transaction (mirror)");
        }
        if (((InternalCompass)this.getIndexCompass()).getTransactionFactory().getTransactionBoundSession() != null) {
            throw new CompassGpsException("index() operation is not allowed to be called within a transaction (index)");
        }
        if (this.isPerformingIndexOperation()) {
            throw new IllegalArgumentException("Indexing alredy in process, not allowed to call index()");
        }
        try {
            this.performingIndexOperation = true;
            this.doIndex(indexPlan);
        }
        finally {
            this.performingIndexOperation = false;
        }
    }

    protected abstract void doIndex(IndexPlan var1) throws CompassGpsException;

    public synchronized void start() throws CompassGpsException {
        this.doStart();
        if (!this.started) {
            for (CompassGpsDevice device : this.devices.values()) {
                device.start();
            }
            this.started = true;
        }
    }

    protected abstract void doStart() throws CompassGpsException;

    protected abstract void doStop() throws CompassGpsException;

    public synchronized void stop() throws CompassGpsException {
        if (this.started) {
            for (CompassGpsDevice device : this.devices.values()) {
                device.stop();
            }
            this.started = false;
        }
        this.doStop();
    }

    public synchronized void refresh() throws CompassGpsException {
        for (CompassGpsDevice device : this.devices.values()) {
            device.refresh();
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isPerformingIndexOperation() {
        return this.performingIndexOperation;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stop();
    }
}

