/*
 * Decompiled with CFR 0.152.
 */
package org.compass.annotations.config.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.compass.annotations.AnalyzerType;
import org.compass.annotations.Cascade;
import org.compass.annotations.EnableAll;
import org.compass.annotations.ExcludeAlias;
import org.compass.annotations.FilterDuplicates;
import org.compass.annotations.Lazy;
import org.compass.annotations.NABoolean;
import org.compass.annotations.SearchAnalyzer;
import org.compass.annotations.SearchAnalyzerFilter;
import org.compass.annotations.SearchAnalyzerFilters;
import org.compass.annotations.SearchAnalyzers;
import org.compass.annotations.SearchConverter;
import org.compass.annotations.SearchConverters;
import org.compass.annotations.SearchSetting;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableAllMetaData;
import org.compass.annotations.SearchableAnalyzerProperty;
import org.compass.annotations.SearchableBoostProperty;
import org.compass.annotations.SearchableCascading;
import org.compass.annotations.SearchableClassConverter;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableConstant;
import org.compass.annotations.SearchableConstants;
import org.compass.annotations.SearchableDynamicMetaData;
import org.compass.annotations.SearchableDynamicMetaDatas;
import org.compass.annotations.SearchableDynamicProperty;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableIdComponent;
import org.compass.annotations.SearchableMetaData;
import org.compass.annotations.SearchableMetaDatas;
import org.compass.annotations.SearchableParent;
import org.compass.annotations.SearchableProperty;
import org.compass.annotations.SearchableReference;
import org.compass.annotations.SearchableSubIndexHash;
import org.compass.annotations.SpellCheck;
import org.compass.annotations.SupportUnmarshall;
import org.compass.annotations.TermVector;
import org.compass.annotations.config.binding.AnnotationsBindingUtils;
import org.compass.core.config.CommonMetaDataLookup;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.binding.AbstractClassMetaDataMappingBinding;
import org.compass.core.config.binding.metadata.ClassMetaData;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.engine.subindex.ConstantSubIndexHash;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.internal.DefaultAllMapping;
import org.compass.core.mapping.internal.InternalCascadeMapping;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.mapping.internal.InternalMapping;
import org.compass.core.mapping.internal.InternalResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassBoostPropertyMapping;
import org.compass.core.mapping.osem.ClassDynamicPropertyMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyAnalyzerController;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.IdComponentMapping;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.PlainCascadeMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.mapping.osem.internal.InternalObjectMapping;
import org.compass.core.metadata.Alias;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsMappingBinding
extends AbstractClassMetaDataMappingBinding {
    public static final Log log = LogFactory.getLog(AnnotationsMappingBinding.class);
    private static final Class[] applicableAnnotations = new Class[]{Searchable.class, SearchConverter.class, SearchConverters.class, SearchAnalyzer.class, SearchAnalyzers.class, SearchAnalyzerFilter.class, SearchAnalyzerFilters.class};
    private CommonMetaDataLookup valueLookup;
    private InternalCompassMapping mapping;
    private ClassMapping classMapping;
    private CompassSettings settings;

    @Override
    public void setUpBinding(InternalCompassMapping mapping, CompassMetaData metaData, CompassSettings settings) {
        super.setUpBinding(mapping, metaData, settings);
        this.mapping = mapping;
        this.valueLookup = new CommonMetaDataLookup(metaData);
        this.settings = settings;
    }

    @Override
    protected boolean isApplicable(ClassMetaData classMetaData) {
        for (Class applicableAnnotation : applicableAnnotations) {
            if (!classMetaData.hasAnnotation(applicableAnnotation.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addPackage(String packageName) throws ConfigurationException, MappingException {
        Package pckg;
        try {
            pckg = ClassUtils.forName(packageName + ".package-info", this.settings.getClassLoader()).getPackage();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return this.processNonSearchableAnnotations(pckg);
    }

    @Override
    public boolean addClass(Class clazz) throws ConfigurationException, MappingException {
        SearchableSubIndexHash searchableSubIndexHash;
        Class annotationClass = clazz;
        boolean found = this.processNonSearchableAnnotations(clazz);
        Searchable searchable = annotationClass.getAnnotation(Searchable.class);
        if (searchable == null) {
            return found;
        }
        String alias = this.getAliasFromSearchableClass(clazz, searchable);
        boolean newClassMapping = false;
        AliasMapping aliasMapping = this.mapping.getAliasMapping(alias);
        if (aliasMapping != null) {
            if (!(aliasMapping instanceof ClassMapping)) {
                throw new MappingException("Defined searchable annotation on a class with alias [" + alias + "] which" + " has other mapping definitions, but it not of type class mapping");
            }
            this.classMapping = (ClassMapping)aliasMapping;
        } else {
            this.classMapping = new ClassMapping();
            newClassMapping = true;
        }
        this.classMapping.setAlias(alias);
        this.classMapping.setName(clazz.getName());
        this.classMapping.setClazz(clazz);
        String subIndex = searchable.subIndex();
        if (!StringUtils.hasLength(subIndex)) {
            subIndex = alias;
        }
        if ((searchableSubIndexHash = annotationClass.getAnnotation(SearchableSubIndexHash.class)) == null) {
            this.classMapping.setSubIndexHash(new ConstantSubIndexHash(subIndex));
        } else {
            SubIndexHash subIndexHash;
            try {
                subIndexHash = searchableSubIndexHash.value().newInstance();
            }
            catch (Exception e) {
                throw new MappingException("Failed to create sub index hash [" + searchableSubIndexHash.value().getName() + "]", e);
            }
            if (subIndexHash instanceof CompassConfigurable) {
                CompassSettings settings = new CompassSettings();
                for (int i = 0; i < searchableSubIndexHash.settings().length; ++i) {
                    SearchSetting setting = searchableSubIndexHash.settings()[i];
                    settings.setSetting(setting.name(), setting.value());
                }
                ((CompassConfigurable)((Object)subIndexHash)).configure(settings);
            }
            this.classMapping.setSubIndexHash(subIndexHash);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Alias [" + this.classMapping.getAlias() + "] is mapped to sub index hash [" + this.classMapping.getSubIndexHash() + "]"));
        }
        DefaultAllMapping allMapping = new DefaultAllMapping();
        SearchableAllMetaData allMetaData = annotationClass.getAnnotation(SearchableAllMetaData.class);
        if (allMetaData != null) {
            if (allMetaData.enable() == EnableAll.TRUE) {
                allMapping.setSupported(true);
            } else if (allMetaData.enable() == EnableAll.FALSE) {
                allMapping.setSupported(false);
            }
            if (allMetaData.excludeAlias() == ExcludeAlias.TRUE) {
                allMapping.setExcludeAlias(true);
            } else if (allMetaData.excludeAlias() == ExcludeAlias.FALSE) {
                allMapping.setExcludeAlias(false);
            }
            if (StringUtils.hasLength(allMetaData.name())) {
                allMapping.setProperty(allMetaData.name());
            }
            if (allMetaData.termVector() != TermVector.NA) {
                allMapping.setTermVector(AnnotationsBindingUtils.convert(allMetaData.termVector()));
            }
            if (allMetaData.spellCheck() == SpellCheck.EXCLUDE) {
                allMapping.setSpellCheck(org.compass.core.mapping.SpellCheck.EXCLUDE);
            } else if (allMetaData.spellCheck() == SpellCheck.INCLUDE) {
                allMapping.setSpellCheck(org.compass.core.mapping.SpellCheck.INCLUDE);
            } else if (allMetaData.spellCheck() == SpellCheck.NA) {
                allMapping.setSpellCheck(org.compass.core.mapping.SpellCheck.NA);
            }
            if (allMetaData.includePropertiesWithNoMappings() == NABoolean.TRUE) {
                allMapping.setIncludePropertiesWithNoMappings(true);
            } else if (allMetaData.includePropertiesWithNoMappings() == NABoolean.FALSE) {
                allMapping.setIncludePropertiesWithNoMappings(false);
            }
            allMapping.setOmitNorms(AnnotationsBindingUtils.convert(allMetaData.omitNorms()));
            allMapping.setOmitTf(AnnotationsBindingUtils.convert(allMetaData.omitTf()));
        }
        this.classMapping.setAllMapping(allMapping);
        if (searchable.spellCheck() == SpellCheck.NA) {
            this.classMapping.setSpellCheck(org.compass.core.mapping.SpellCheck.NA);
        } else if (searchable.spellCheck() == SpellCheck.EXCLUDE) {
            this.classMapping.setSpellCheck(org.compass.core.mapping.SpellCheck.EXCLUDE);
        } else if (searchable.spellCheck() == SpellCheck.INCLUDE) {
            this.classMapping.setSpellCheck(org.compass.core.mapping.SpellCheck.INCLUDE);
        }
        this.classMapping.setBoost(searchable.boost());
        this.classMapping.setRoot(searchable.root());
        this.classMapping.setPoly(searchable.poly());
        if (!Object.class.equals((Object)searchable.polyClass())) {
            this.classMapping.setPolyClass(searchable.polyClass());
        }
        if (StringUtils.hasLength(searchable.analyzer())) {
            this.classMapping.setAnalyzer(searchable.analyzer());
        }
        if (searchable.supportUnmarshall() == SupportUnmarshall.TRUE) {
            this.classMapping.setSupportUnmarshall(true);
        } else if (searchable.supportUnmarshall() == SupportUnmarshall.FALSE) {
            this.classMapping.setSupportUnmarshall(false);
        }
        if (searchable.filterDuplicates() == FilterDuplicates.TRUE) {
            this.classMapping.setFilterDuplicates(true);
        } else if (searchable.filterDuplicates() == FilterDuplicates.FALSE) {
            this.classMapping.setFilterDuplicates(false);
        }
        this.classMapping.setManagedId(AnnotationsBindingUtils.convert(searchable.managedId()));
        this.bindConverter(this.classMapping, searchable.converter());
        this.processAnnotatedClass(annotationClass);
        if (newClassMapping) {
            this.mapping.addMapping(this.classMapping);
        }
        this.classMapping = null;
        return true;
    }

    private boolean processNonSearchableAnnotations(AnnotatedElement annotatedElement) {
        boolean found = false;
        if (annotatedElement.isAnnotationPresent(SearchConverter.class)) {
            found = true;
            this.bindConverter(annotatedElement.getAnnotation(SearchConverter.class));
        }
        if (annotatedElement.isAnnotationPresent(SearchConverters.class)) {
            found = true;
            SearchConverters searchConverters = annotatedElement.getAnnotation(SearchConverters.class);
            for (Annotation annotation : searchConverters.value()) {
                this.bindConverter((SearchConverter)annotation);
            }
        }
        if (annotatedElement.isAnnotationPresent(SearchAnalyzer.class)) {
            found = true;
            this.bindAnalyzer(annotatedElement.getAnnotation(SearchAnalyzer.class));
        }
        if (annotatedElement.isAnnotationPresent(SearchAnalyzers.class)) {
            found = true;
            SearchAnalyzers searchAnalyzers = annotatedElement.getAnnotation(SearchAnalyzers.class);
            for (Annotation annotation : searchAnalyzers.value()) {
                this.bindAnalyzer((SearchAnalyzer)annotation);
            }
        }
        if (annotatedElement.isAnnotationPresent(SearchAnalyzerFilter.class)) {
            found = true;
            this.bindAnalyzerFilter(annotatedElement.getAnnotation(SearchAnalyzerFilter.class));
        }
        if (annotatedElement.isAnnotationPresent(SearchAnalyzerFilters.class)) {
            found = true;
            SearchAnalyzerFilters searchAnalyzerFilters = annotatedElement.getAnnotation(SearchAnalyzerFilters.class);
            for (Annotation annotation : searchAnalyzerFilters.value()) {
                this.bindAnalyzerFilter((SearchAnalyzerFilter)annotation);
            }
        }
        return found;
    }

    private void bindAnalyzerFilter(SearchAnalyzerFilter searchAnalyzerFilter) throws ConfigurationException, MappingException {
        ArrayList<String> settingsNames = new ArrayList<String>();
        ArrayList<String> settingsValues = new ArrayList<String>();
        settingsNames.add("type");
        settingsValues.add(searchAnalyzerFilter.type().getName());
        for (SearchSetting setting : searchAnalyzerFilter.settings()) {
            settingsNames.add(setting.name());
            settingsValues.add(setting.value());
        }
        this.settings.setGroupSettings("compass.engine.analyzerfilter", searchAnalyzerFilter.name(), settingsNames.toArray(new String[settingsNames.size()]), settingsValues.toArray(new String[settingsValues.size()]));
    }

    private void bindAnalyzer(SearchAnalyzer searchAnalyzer) throws ConfigurationException, MappingException {
        StringBuffer sb;
        ArrayList<String> settingsNames = new ArrayList<String>();
        ArrayList<String> settingsValues = new ArrayList<String>();
        settingsNames.add("type");
        if (searchAnalyzer.type() == AnalyzerType.CustomAnalyzer) {
            if (Analyzer.class.equals(searchAnalyzer.analyzerClass())) {
                throw new ConfigurationException("SearchableAnalyzer [" + searchAnalyzer.name() + "] has " + "type of [" + (Object)((Object)AnalyzerType.CustomAnalyzer) + "] but does not set analyzerClass");
            }
            settingsValues.add(searchAnalyzer.analyzerClass().getName());
        } else {
            settingsValues.add(searchAnalyzer.type().toString());
        }
        if (searchAnalyzer.type() == AnalyzerType.Snowball) {
            settingsNames.add("name");
            settingsValues.add(searchAnalyzer.snowballType().toString());
        }
        if (searchAnalyzer.stopWords().length > 0) {
            sb = new StringBuffer();
            if (searchAnalyzer.addStopWords()) {
                sb.append("+");
            }
            for (String stopword : searchAnalyzer.stopWords()) {
                sb.append(stopword).append(",");
            }
            settingsNames.add("stopwords");
            settingsValues.add(sb.toString());
        }
        if (searchAnalyzer.filters().length > 0) {
            sb = new StringBuffer();
            for (String filter : searchAnalyzer.filters()) {
                sb.append(filter).append(",");
            }
            settingsNames.add("filters");
            settingsValues.add(sb.toString());
        }
        for (SearchSetting setting : searchAnalyzer.settings()) {
            settingsNames.add(setting.name());
            settingsValues.add(setting.value());
        }
        this.settings.setGroupSettings("compass.engine.analyzer", searchAnalyzer.name(), settingsNames.toArray(new String[settingsNames.size()]), settingsValues.toArray(new String[settingsValues.size()]));
    }

    private void bindConverter(SearchConverter searchConverter) throws ConfigurationException, MappingException {
        String[] settingsNames = new String[searchConverter.settings().length + 2];
        Object[] settingsValues = new String[searchConverter.settings().length + 2];
        for (int i = 0; i < searchConverter.settings().length; ++i) {
            SearchSetting setting = searchConverter.settings()[i];
            settingsNames[i] = setting.name();
            settingsValues[i] = setting.value();
        }
        settingsNames[i] = "type";
        settingsValues[i] = searchConverter.type().getName();
        settingsNames[++i] = "registerClass";
        if (!searchConverter.registerClass().equals(Object.class)) {
            settingsValues[i] = searchConverter.registerClass().getName();
        }
        this.settings.setGroupSettings("compass.converter", searchConverter.name(), settingsNames, settingsValues);
    }

    private String getAliasFromSearchableClass(Class clazz, Searchable searchable) {
        String alias = searchable.alias();
        if (!StringUtils.hasLength(alias)) {
            alias = ClassUtils.getShortName(clazz);
        } else {
            Alias aliasLookup = this.valueLookup.lookupAlias(alias);
            if (aliasLookup != null) {
                alias = aliasLookup.getName();
            }
        }
        return alias;
    }

    /*
     * WARNING - void declaration
     */
    private void processAnnotatedClass(Class<?> clazz) {
        Searchable searchable;
        String[] extend;
        SearchableDynamicMetaDatas searchableDynamicMetaDatas;
        SearchableDynamicMetaData searchableDynamicMetaData;
        SearchableConstants searchableConstants;
        Class<?>[] interfaces;
        if (clazz.equals(Class.class)) {
            return;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && !superClazz.equals(Object.class)) {
            this.processAnnotatedClass(superClazz);
        }
        for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
            this.processAnnotatedClass(anInterface);
        }
        SearchableConstant searchableConstant = clazz.getAnnotation(SearchableConstant.class);
        if (searchableConstant != null) {
            this.bindConstantMetaData(searchableConstant);
        }
        if ((searchableConstants = clazz.getAnnotation(SearchableConstants.class)) != null) {
            for (SearchableConstant metaData : searchableConstants.value()) {
                this.bindConstantMetaData(metaData);
            }
        }
        if ((searchableDynamicMetaData = clazz.getAnnotation(SearchableDynamicMetaData.class)) != null) {
            this.bindDynamicMetaData(searchableDynamicMetaData);
        }
        if ((searchableDynamicMetaDatas = clazz.getAnnotation(SearchableDynamicMetaDatas.class)) != null) {
            void var10_22;
            SearchableDynamicMetaData[] arr$ = searchableDynamicMetaDatas.value();
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_22 < len$) {
                SearchableDynamicMetaData metaData = arr$[var10_22];
                this.bindDynamicMetaData(metaData);
                ++var10_22;
            }
        }
        if (clazz.isAnnotationPresent(Searchable.class) && (extend = (searchable = clazz.getAnnotation(Searchable.class)).extend()).length != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.classMapping.getExtendedAliases() != null) {
                arrayList.addAll(Arrays.asList(this.classMapping.getExtendedAliases()));
            }
            for (String extendedAlias : extend) {
                Alias extendedAliasLookup = this.valueLookup.lookupAlias(extendedAlias);
                if (extendedAliasLookup == null) {
                    arrayList.add(extendedAlias);
                    continue;
                }
                arrayList.add(extendedAliasLookup.getName());
            }
            this.classMapping.setExtendedAliases(arrayList.toArray(new String[arrayList.size()]));
        }
        ArrayList extendedClasses = new ArrayList();
        if (clazz.getSuperclass() != null) {
            extendedClasses.add(clazz.getSuperclass());
        }
        extendedClasses.addAll(Arrays.asList(clazz.getInterfaces()));
        for (Class clazz2 : extendedClasses) {
            if (!clazz2.isAnnotationPresent(Searchable.class)) continue;
            Searchable superSearchable = clazz2.getAnnotation(Searchable.class);
            String string = this.getAliasFromSearchableClass(clazz2, superSearchable);
            HashSet<String> extendedMappings = new HashSet<String>();
            if (this.classMapping.getExtendedAliases() != null) {
                extendedMappings.addAll(Arrays.asList(this.classMapping.getExtendedAliases()));
            }
            extendedMappings.add(string);
            this.classMapping.setExtendedAliases(extendedMappings.toArray(new String[extendedMappings.size()]));
        }
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                this.processsAnnotatedElement(clazz, field.getName(), "field", field.getType(), field.getGenericType(), annotation, field);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge() || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).getParameterTypes().length != 0 || ((Method)accessibleObject).getReturnType() == Void.TYPE || !((Method)accessibleObject).getName().startsWith("get") && !((Method)accessibleObject).getName().startsWith("is")) continue;
            for (Annotation annotation : accessibleObject.getAnnotations()) {
                this.processsAnnotatedElement(clazz, ClassUtils.getShortNameForMethod((Method)accessibleObject), "property", ((Method)accessibleObject).getReturnType(), ((Method)accessibleObject).getGenericReturnType(), annotation, accessibleObject);
            }
        }
    }

    private void processsAnnotatedElement(Class<?> searchableClass, String name, String accessor, Class<?> clazz, Type type, Annotation annotation, AnnotatedElement annotatedElement) {
        if (annotation instanceof SearchableId) {
            ClassIdPropertyMapping classPropertyMapping = new ClassIdPropertyMapping();
            SearchableId searchableId = (SearchableId)annotation;
            this.bindObjectMapping(classPropertyMapping, accessor, name, searchableId.accessor(), searchableClass);
            this.bindClassPropertyIdMapping(searchableId, classPropertyMapping, clazz, type, annotatedElement);
            this.classMapping.addMapping(classPropertyMapping);
        } else if (annotation instanceof SearchableIdComponent) {
            IdComponentMapping componentMapping = new IdComponentMapping();
            SearchableIdComponent searchableComponent = (SearchableIdComponent)annotation;
            this.bindObjectMapping(componentMapping, accessor, name, searchableComponent.accessor(), searchableClass);
            this.bindComponent(searchableComponent, (ComponentMapping)componentMapping, clazz, type);
            this.classMapping.addMapping(componentMapping);
        } else if (annotation instanceof SearchableProperty) {
            ClassPropertyMapping classPropertyMapping = new ClassPropertyMapping();
            SearchableProperty searchableProperty = (SearchableProperty)annotation;
            this.bindObjectMapping(classPropertyMapping, accessor, name, searchableProperty.accessor(), searchableClass);
            this.bindClassPropertyMapping(searchableProperty, classPropertyMapping, annotatedElement, clazz, type);
            this.classMapping.addMapping(classPropertyMapping);
        } else if (annotation instanceof SearchableDynamicProperty) {
            ClassDynamicPropertyMapping dynamicPropertyMapping = new ClassDynamicPropertyMapping();
            SearchableDynamicProperty searchableDynamicProperty = (SearchableDynamicProperty)annotation;
            this.bindObjectMapping(dynamicPropertyMapping, accessor, name, searchableDynamicProperty.accessor(), searchableClass);
            this.bindClassDynamicPropertyMapping(searchableDynamicProperty, dynamicPropertyMapping, annotatedElement, clazz, type);
            this.classMapping.addMapping(dynamicPropertyMapping);
        } else if (annotation instanceof SearchableComponent) {
            ComponentMapping componentMapping = new ComponentMapping();
            SearchableComponent searchableComponent = (SearchableComponent)annotation;
            this.bindObjectMapping(componentMapping, accessor, name, searchableComponent.accessor(), searchableClass);
            this.bindComponent(searchableComponent, componentMapping, clazz, type);
            this.classMapping.addMapping(componentMapping);
        } else if (annotation instanceof SearchableReference) {
            ReferenceMapping referenceMapping = new ReferenceMapping();
            SearchableReference searchableReference = (SearchableReference)annotation;
            this.bindObjectMapping(referenceMapping, accessor, name, searchableReference.accessor(), searchableClass);
            this.bindReference(searchableReference, referenceMapping, clazz, type);
            this.classMapping.addMapping(referenceMapping);
        } else if (annotation instanceof SearchableAnalyzerProperty) {
            ClassPropertyAnalyzerController analyzerMapping = new ClassPropertyAnalyzerController();
            SearchableAnalyzerProperty searchableAnalyzerProperty = (SearchableAnalyzerProperty)annotation;
            this.bindObjectMapping(analyzerMapping, accessor, name, searchableAnalyzerProperty.accessor(), searchableClass);
            this.bindAnalyzer(searchableAnalyzerProperty, analyzerMapping, clazz, type);
            this.classMapping.addMapping(analyzerMapping);
        } else if (annotation instanceof SearchableBoostProperty) {
            ClassBoostPropertyMapping boostPropertyMapping = new ClassBoostPropertyMapping();
            SearchableBoostProperty searchableBoostProperty = (SearchableBoostProperty)annotation;
            this.bindObjectMapping(boostPropertyMapping, accessor, name, searchableBoostProperty.accessor(), searchableClass);
            this.bindBoost(searchableBoostProperty, boostPropertyMapping, clazz, type);
            this.classMapping.addMapping(boostPropertyMapping);
        } else if (annotation instanceof SearchableParent) {
            ParentMapping parentMapping = new ParentMapping();
            SearchableParent searchableParent = (SearchableParent)annotation;
            this.bindObjectMapping(parentMapping, accessor, name, searchableParent.accessor(), searchableClass);
            this.bindParent(searchableParent, parentMapping, clazz, type);
            this.classMapping.addMapping(parentMapping);
        } else if (annotation instanceof SearchableCascading) {
            PlainCascadeMapping cascadeMapping = new PlainCascadeMapping();
            SearchableCascading searchableCascading = (SearchableCascading)annotation;
            this.bindObjectMapping(cascadeMapping, accessor, name, searchableCascading.accessor(), searchableClass);
            this.bindCascade(searchableCascading, cascadeMapping, clazz, type);
            this.classMapping.addMapping(cascadeMapping);
        } else if ((annotation instanceof SearchableMetaData || annotation instanceof SearchableMetaDatas) && !annotatedElement.isAnnotationPresent(SearchableProperty.class) && !annotatedElement.isAnnotationPresent(SearchableId.class)) {
            throw new MappingException("SearchableMetaData/s annotation exists without a SearchableProperty/Id, it will be ignored");
        }
    }

    private void bindCascade(SearchableCascading searchableCascading, PlainCascadeMapping cascadeMapping, Class<?> clazz, Type type) {
        this.bindConverter(cascadeMapping, searchableCascading.converter(), clazz, type);
        this.bindCascades(searchableCascading.cascade(), cascadeMapping);
    }

    private void bindParent(SearchableParent searchableParent, ParentMapping parentMapping, Class<?> clazz, Type type) {
        this.bindConverter(parentMapping, searchableParent.converter(), clazz, type);
        this.bindCascades(searchableParent.cascade(), parentMapping);
    }

    private void bindBoost(SearchableBoostProperty searchableBoostProperty, ClassBoostPropertyMapping boostPropertyMapping, Class<?> clazz, Type type) {
        this.bindConverter(boostPropertyMapping, searchableBoostProperty.converter(), clazz, type);
        boostPropertyMapping.setDefaultBoost(searchableBoostProperty.defaultValue());
    }

    private void bindAnalyzer(SearchableAnalyzerProperty searchableAnalyzerProperty, ClassPropertyAnalyzerController analyzerMapping, Class<?> clazz, Type type) {
        this.bindConverter(analyzerMapping, searchableAnalyzerProperty.converter(), clazz, type);
        if (StringUtils.hasLength(searchableAnalyzerProperty.nullAnalyzer())) {
            analyzerMapping.setNullAnalyzer(searchableAnalyzerProperty.nullAnalyzer());
        }
    }

    private void bindReference(SearchableReference searchableReference, ReferenceMapping referenceMapping, Class<?> clazz, Type type) {
        this.bindConverter(referenceMapping, searchableReference.converter(), clazz, type);
        if (StringUtils.hasLength(searchableReference.refAlias())) {
            referenceMapping.setRefAliases(this.getAliases(searchableReference.refAlias()));
        } else {
            referenceMapping.setRefClass(AnnotationsBindingUtils.getCollectionParameterClass(clazz, type));
        }
        if (StringUtils.hasLength(searchableReference.refComponentAlias())) {
            referenceMapping.setRefCompAlias(searchableReference.refComponentAlias());
        }
        if (searchableReference.lazy() == Lazy.FALSE) {
            referenceMapping.setLazy(false);
        } else if (searchableReference.lazy() == Lazy.TRUE) {
            referenceMapping.setLazy(true);
        }
        this.bindCascades(searchableReference.cascade(), referenceMapping);
    }

    private void bindComponent(SearchableComponent searchableComponent, ComponentMapping componentMapping, Class<?> clazz, Type type) {
        this.bindConverter(componentMapping, searchableComponent.converter(), clazz, type);
        if (StringUtils.hasLength(searchableComponent.refAlias())) {
            componentMapping.setRefAliases(this.getAliases(searchableComponent.refAlias()));
        } else {
            componentMapping.setRefClass(AnnotationsBindingUtils.getCollectionParameterClass(clazz, type));
        }
        componentMapping.setMaxDepth(searchableComponent.maxDepth());
        if (StringUtils.hasText(searchableComponent.prefix())) {
            componentMapping.setPrefix(searchableComponent.prefix());
        }
        componentMapping.setOverrideByName(searchableComponent.override());
        this.bindCascades(searchableComponent.cascade(), componentMapping);
    }

    private void bindComponent(SearchableIdComponent searchableComponent, ComponentMapping componentMapping, Class<?> clazz, Type type) {
        this.bindConverter(componentMapping, searchableComponent.converter(), clazz, type);
        if (StringUtils.hasLength(searchableComponent.refAlias())) {
            componentMapping.setRefAliases(this.getAliases(searchableComponent.refAlias()));
        } else {
            componentMapping.setRefClass(AnnotationsBindingUtils.getCollectionParameterClass(clazz, type));
        }
        componentMapping.setMaxDepth(searchableComponent.maxDepth());
        if (StringUtils.hasText(searchableComponent.prefix())) {
            componentMapping.setPrefix(searchableComponent.prefix());
        }
        componentMapping.setOverrideByName(searchableComponent.override());
        this.bindCascades(searchableComponent.cascade(), componentMapping);
    }

    private void bindCascades(Cascade[] cascades, InternalCascadeMapping cascadeMapping) {
        if (cascades == null || cascades.length == 0) {
            return;
        }
        org.compass.core.mapping.Cascade[] mappingCascades = new org.compass.core.mapping.Cascade[cascades.length];
        for (int i = 0; i < cascades.length; ++i) {
            mappingCascades[i] = AnnotationsBindingUtils.convert(cascades[i]);
        }
        cascadeMapping.setCascades(mappingCascades);
    }

    private void bindClassPropertyIdMapping(SearchableId searchableProp, ClassIdPropertyMapping classPropertyMapping, Class<?> clazz, Type type, AnnotatedElement annotatedElement) throws MappingException {
        this.bindConverter(classPropertyMapping, searchableProp.idConverter());
        classPropertyMapping.setBoost(searchableProp.boost());
        classPropertyMapping.setManagedId(AnnotationsBindingUtils.convert(searchableProp.managedId()));
        classPropertyMapping.setManagedIdIndex(AnnotationsBindingUtils.convert(searchableProp.managedIdIndex()));
        classPropertyMapping.setOverrideByName(searchableProp.override());
        SearchableMetaData metaData = annotatedElement.getAnnotation(SearchableMetaData.class);
        SearchableMetaDatas metaDatas = annotatedElement.getAnnotation(SearchableMetaDatas.class);
        if (StringUtils.hasLength(searchableProp.converter())) {
            classPropertyMapping.setManagedIdConverterName(searchableProp.converter());
        } else {
            classPropertyMapping.setManagedIdConverter(this.getConverter(clazz, type));
        }
        if (StringUtils.hasLength(searchableProp.name())) {
            ClassPropertyMetaDataMapping mdMapping = new ClassPropertyMetaDataMapping();
            String name = searchableProp.name();
            if (!StringUtils.hasLength(name)) {
                name = classPropertyMapping.getName();
            }
            mdMapping.setName(this.valueLookup.lookupMetaDataName(name));
            mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
            mdMapping.setBoost(classPropertyMapping.getBoost());
            mdMapping.setAccessor(classPropertyMapping.getAccessor());
            mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
            this.bindConverter(mdMapping, searchableProp.converter(), clazz, type);
            this.bindSpellCheck(mdMapping, searchableProp.spellCheck());
            mdMapping.setStore(AnnotationsBindingUtils.convert(searchableProp.store()));
            mdMapping.setIndex(AnnotationsBindingUtils.convert(searchableProp.index()));
            mdMapping.setTermVector(AnnotationsBindingUtils.convert(searchableProp.termVector()));
            mdMapping.setOmitNorms(AnnotationsBindingUtils.convert(searchableProp.omitNorms()));
            mdMapping.setOmitTf(AnnotationsBindingUtils.convert(searchableProp.omitTf()));
            mdMapping.setReverse(AnnotationsBindingUtils.convert(searchableProp.reverse()));
            this.handleFormat(mdMapping, name, searchableProp.format());
            if (StringUtils.hasLength(searchableProp.analyzer())) {
                mdMapping.setAnalyzer(searchableProp.analyzer());
            } else {
                mdMapping.setAnalyzer(this.classMapping.getAnalyzer());
            }
            mdMapping.setExcludeFromAll(AnnotationsBindingUtils.convert(searchableProp.excludeFromAll()));
            classPropertyMapping.addMapping(mdMapping);
        }
        if (metaData != null) {
            this.bindMetaData(metaData, classPropertyMapping, clazz, type);
        }
        if (metaDatas != null) {
            for (SearchableMetaData searchableMetaData : metaDatas.value()) {
                this.bindMetaData(searchableMetaData, classPropertyMapping, clazz, type);
            }
        }
    }

    private void bindClassDynamicPropertyMapping(SearchableDynamicProperty searchableDynamicProperty, ClassDynamicPropertyMapping dynamicPropertyMapping, AnnotatedElement annotatedElement, Class<?> clazz, Type type) {
        this.bindConverter(dynamicPropertyMapping, searchableDynamicProperty.converter(), clazz, type);
        dynamicPropertyMapping.setOverrideByName(searchableDynamicProperty.override());
        if (StringUtils.hasText(searchableDynamicProperty.namePrefix())) {
            dynamicPropertyMapping.setNamePrefix(searchableDynamicProperty.namePrefix());
        }
        if (StringUtils.hasText(searchableDynamicProperty.nameProperty())) {
            dynamicPropertyMapping.setNameProperty(searchableDynamicProperty.nameProperty());
        }
        if (StringUtils.hasText(searchableDynamicProperty.valueProperty())) {
            dynamicPropertyMapping.setValueProperty(searchableDynamicProperty.valueProperty());
        }
        if (StringUtils.hasText(searchableDynamicProperty.nameFormat())) {
            dynamicPropertyMapping.setNameFormat(searchableDynamicProperty.nameFormat());
        }
        if (StringUtils.hasText(searchableDynamicProperty.valueFormat())) {
            dynamicPropertyMapping.setValueFormat(searchableDynamicProperty.valueFormat());
        }
        if (StringUtils.hasText(searchableDynamicProperty.nameConverter())) {
            dynamicPropertyMapping.setNameConverterName(searchableDynamicProperty.nameConverter());
        }
        if (StringUtils.hasText(searchableDynamicProperty.valueConverter())) {
            dynamicPropertyMapping.setValueConverterName(searchableDynamicProperty.valueConverter());
        }
        dynamicPropertyMapping.getResourcePropertyMapping().setBoost(searchableDynamicProperty.boost());
        dynamicPropertyMapping.getResourcePropertyMapping().setStore(AnnotationsBindingUtils.convert(searchableDynamicProperty.store()));
        dynamicPropertyMapping.getResourcePropertyMapping().setIndex(AnnotationsBindingUtils.convert(searchableDynamicProperty.index()));
        dynamicPropertyMapping.getResourcePropertyMapping().setTermVector(AnnotationsBindingUtils.convert(searchableDynamicProperty.termVector()));
        dynamicPropertyMapping.getResourcePropertyMapping().setOmitNorms(AnnotationsBindingUtils.convert(searchableDynamicProperty.omitNorms()));
        dynamicPropertyMapping.getResourcePropertyMapping().setOmitTf(AnnotationsBindingUtils.convert(searchableDynamicProperty.omitTf()));
        if (StringUtils.hasLength(searchableDynamicProperty.nullValue())) {
            dynamicPropertyMapping.getResourcePropertyMapping().setNullValue(searchableDynamicProperty.nullValue());
        }
    }

    private void bindClassPropertyMapping(SearchableProperty searchableProp, ClassPropertyMapping classPropertyMapping, AnnotatedElement annotatedElement, Class<?> clazz, Type type) throws MappingException {
        boolean hasMetaDataAnnotations;
        this.bindConverter(classPropertyMapping, searchableProp.propertyConverter());
        if (!searchableProp.type().equals(Object.class)) {
            classPropertyMapping.setClassName(searchableProp.type().getName());
        } else {
            classPropertyMapping.setClassName(AnnotationsBindingUtils.getCollectionParameterClassName(clazz, type));
        }
        if (StringUtils.hasLength(searchableProp.converter())) {
            classPropertyMapping.setManagedIdConverterName(searchableProp.converter());
        } else {
            classPropertyMapping.setManagedIdConverter(this.getConverter(clazz, type));
        }
        classPropertyMapping.setBoost(searchableProp.boost());
        classPropertyMapping.setManagedId(AnnotationsBindingUtils.convert(searchableProp.managedId()));
        classPropertyMapping.setManagedIdIndex(AnnotationsBindingUtils.convert(searchableProp.managedIdIndex()));
        classPropertyMapping.setOverrideByName(searchableProp.override());
        SearchableMetaData metaData = annotatedElement.getAnnotation(SearchableMetaData.class);
        SearchableMetaDatas metaDatas = annotatedElement.getAnnotation(SearchableMetaDatas.class);
        boolean bl = hasMetaDataAnnotations = metaData != null || metaDatas != null;
        if (StringUtils.hasLength(searchableProp.name()) || !hasMetaDataAnnotations) {
            ClassPropertyMetaDataMapping mdMapping = new ClassPropertyMetaDataMapping();
            String name = searchableProp.name();
            if (!StringUtils.hasLength(name)) {
                name = classPropertyMapping.getName();
            }
            mdMapping.setName(this.valueLookup.lookupMetaDataName(name));
            mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
            mdMapping.setBoost(classPropertyMapping.getBoost());
            this.bindConverter(mdMapping, searchableProp.converter(), clazz, type);
            this.bindSpellCheck(mdMapping, searchableProp.spellCheck());
            mdMapping.setAccessor(classPropertyMapping.getAccessor());
            mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
            mdMapping.setStore(AnnotationsBindingUtils.convert(searchableProp.store()));
            mdMapping.setIndex(AnnotationsBindingUtils.convert(searchableProp.index()));
            mdMapping.setTermVector(AnnotationsBindingUtils.convert(searchableProp.termVector()));
            mdMapping.setOmitNorms(AnnotationsBindingUtils.convert(searchableProp.omitNorms()));
            mdMapping.setOmitTf(AnnotationsBindingUtils.convert(searchableProp.omitTf()));
            mdMapping.setReverse(AnnotationsBindingUtils.convert(searchableProp.reverse()));
            this.handleFormat(mdMapping, name, searchableProp.format());
            mdMapping.setInternal(false);
            if (StringUtils.hasLength(searchableProp.analyzer())) {
                mdMapping.setAnalyzer(searchableProp.analyzer());
            } else {
                mdMapping.setAnalyzer(this.classMapping.getAnalyzer());
            }
            if (StringUtils.hasLength(searchableProp.nullValue())) {
                mdMapping.setNullValue(searchableProp.nullValue());
            }
            mdMapping.setExcludeFromAll(AnnotationsBindingUtils.convert(searchableProp.excludeFromAll()));
            classPropertyMapping.addMapping(mdMapping);
        }
        if (metaData != null) {
            this.bindMetaData(metaData, classPropertyMapping, clazz, type);
        }
        if (metaDatas != null) {
            for (SearchableMetaData searchableMetaData : metaDatas.value()) {
                this.bindMetaData(searchableMetaData, classPropertyMapping, clazz, type);
            }
        }
    }

    private void bindMetaData(SearchableMetaData searchableMetaData, ClassPropertyMapping classPropertyMapping, Class<?> clazz, Type type) {
        ClassPropertyMetaDataMapping mdMapping = new ClassPropertyMetaDataMapping();
        String name = searchableMetaData.name();
        mdMapping.setName(this.valueLookup.lookupMetaDataName(name));
        mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
        if (searchableMetaData.boost() == 1.0f) {
            mdMapping.setBoost(classPropertyMapping.getBoost());
        } else {
            mdMapping.setBoost(searchableMetaData.boost());
        }
        this.bindConverter(mdMapping, searchableMetaData.converter(), clazz, type);
        this.bindSpellCheck(mdMapping, searchableMetaData.spellCheck());
        mdMapping.setAccessor(classPropertyMapping.getAccessor());
        mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
        mdMapping.setStore(AnnotationsBindingUtils.convert(searchableMetaData.store()));
        mdMapping.setIndex(AnnotationsBindingUtils.convert(searchableMetaData.index()));
        mdMapping.setTermVector(AnnotationsBindingUtils.convert(searchableMetaData.termVector()));
        mdMapping.setOmitNorms(AnnotationsBindingUtils.convert(searchableMetaData.omitNorms()));
        mdMapping.setOmitTf(AnnotationsBindingUtils.convert(searchableMetaData.omitTf()));
        mdMapping.setReverse(AnnotationsBindingUtils.convert(searchableMetaData.reverse()));
        this.handleFormat(mdMapping, name, searchableMetaData.format());
        mdMapping.setInternal(false);
        if (StringUtils.hasLength(searchableMetaData.analyzer())) {
            mdMapping.setAnalyzer(searchableMetaData.analyzer());
        } else {
            mdMapping.setAnalyzer(this.classMapping.getAnalyzer());
        }
        if (StringUtils.hasLength(searchableMetaData.nullValue())) {
            mdMapping.setNullValue(searchableMetaData.nullValue());
        }
        mdMapping.setExcludeFromAll(AnnotationsBindingUtils.convert(searchableMetaData.excludeFromAll()));
        classPropertyMapping.addMapping(mdMapping);
    }

    private void bindDynamicMetaData(SearchableDynamicMetaData searchableMetaData) {
        DynamicMetaDataMapping mdMapping = new DynamicMetaDataMapping();
        String name = searchableMetaData.name();
        mdMapping.setName(this.valueLookup.lookupMetaDataName(name));
        mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
        mdMapping.setBoost(searchableMetaData.boost());
        mdMapping.setOverrideByName(searchableMetaData.override());
        mdMapping.setConverterName(searchableMetaData.converter());
        mdMapping.setExpression(searchableMetaData.expression());
        if (StringUtils.hasLength(searchableMetaData.format())) {
            mdMapping.setFormat(searchableMetaData.format());
        }
        mdMapping.setType(searchableMetaData.type());
        mdMapping.setStore(AnnotationsBindingUtils.convert(searchableMetaData.store()));
        mdMapping.setIndex(AnnotationsBindingUtils.convert(searchableMetaData.index()));
        mdMapping.setTermVector(AnnotationsBindingUtils.convert(searchableMetaData.termVector()));
        mdMapping.setReverse(AnnotationsBindingUtils.convert(searchableMetaData.reverse()));
        mdMapping.setInternal(false);
        this.bindSpellCheck(mdMapping, searchableMetaData.spellCheck());
        if (StringUtils.hasLength(searchableMetaData.analyzer())) {
            mdMapping.setAnalyzer(searchableMetaData.analyzer());
        } else {
            mdMapping.setAnalyzer(this.classMapping.getAnalyzer());
        }
        if (StringUtils.hasLength(searchableMetaData.nullValue())) {
            mdMapping.setNullValue(searchableMetaData.nullValue());
        }
        mdMapping.setExcludeFromAll(AnnotationsBindingUtils.convert(searchableMetaData.excludeFromAll()));
        this.classMapping.addMapping(mdMapping);
    }

    private void bindConstantMetaData(SearchableConstant searchableConstant) {
        ConstantMetaDataMapping constantMapping = new ConstantMetaDataMapping();
        constantMapping.setName(this.valueLookup.lookupMetaDataName(searchableConstant.name()));
        constantMapping.setBoost(searchableConstant.boost());
        constantMapping.setStore(AnnotationsBindingUtils.convert(searchableConstant.store()));
        constantMapping.setIndex(AnnotationsBindingUtils.convert(searchableConstant.index()));
        constantMapping.setTermVector(AnnotationsBindingUtils.convert(searchableConstant.termVector()));
        constantMapping.setOmitNorms(AnnotationsBindingUtils.convert(searchableConstant.omitNorms()));
        constantMapping.setOmitTf(AnnotationsBindingUtils.convert(searchableConstant.omitTf()));
        if (StringUtils.hasLength(searchableConstant.analyzer())) {
            constantMapping.setAnalyzer(searchableConstant.analyzer());
        } else {
            constantMapping.setAnalyzer(this.classMapping.getAnalyzer());
        }
        constantMapping.setExcludeFromAll(AnnotationsBindingUtils.convert(searchableConstant.excludeFromAll()));
        constantMapping.setOverrideByName(searchableConstant.override());
        for (String value : searchableConstant.values()) {
            constantMapping.addMetaDataValue(this.valueLookup.lookupMetaDataValue(value));
        }
        this.bindSpellCheck(constantMapping, searchableConstant.spellCheck());
        this.classMapping.addMapping(constantMapping);
    }

    private void bindConverter(InternalMapping mapping, String converterName) {
        this.bindConverter(mapping, converterName, null, null);
    }

    private void bindSpellCheck(InternalResourcePropertyMapping mapping, SpellCheck spellCheck) {
        if (spellCheck == SpellCheck.EXCLUDE) {
            mapping.setSpellCheck(org.compass.core.mapping.SpellCheck.EXCLUDE);
        } else if (spellCheck == SpellCheck.INCLUDE) {
            mapping.setSpellCheck(org.compass.core.mapping.SpellCheck.INCLUDE);
        } else if (spellCheck == SpellCheck.NA) {
            mapping.setSpellCheck(org.compass.core.mapping.SpellCheck.NA);
        }
    }

    private void bindConverter(InternalMapping mapping, String converterName, Class<?> clazz, Type type) {
        if (StringUtils.hasLength(converterName)) {
            mapping.setConverterName(converterName);
            return;
        }
        if (clazz == null) {
            return;
        }
        mapping.setConverter(this.getConverter(clazz, type));
    }

    public Converter getConverter(Class<?> clazz, Type type) {
        Converter objConverter;
        SearchableClassConverter searchableClassConverter;
        Class<?> actualClass = AnnotationsBindingUtils.getCollectionParameterClass(clazz, type);
        if (actualClass == null) {
            actualClass = clazz;
        }
        if ((searchableClassConverter = actualClass.getAnnotation(SearchableClassConverter.class)) == null) {
            return null;
        }
        try {
            objConverter = searchableClassConverter.value().newInstance();
        }
        catch (Exception e) {
            throw new MappingException("Failed to create converter [" + searchableClassConverter.value().getName() + "]", e);
        }
        if (!(objConverter instanceof Converter)) {
            throw new MappingException("[" + searchableClassConverter + "] does not implement Converter interface");
        }
        Converter converter = objConverter;
        if (searchableClassConverter.settings().length > 0 && !(converter instanceof CompassConfigurable)) {
            throw new MappingException("[" + searchableClassConverter + "] does not implement CompassConfigurable" + " interface, but has settings set, please implement it so settings can be injected");
        }
        if (converter instanceof CompassConfigurable) {
            CompassSettings settings = new CompassSettings();
            for (int i = 0; i < searchableClassConverter.settings().length; ++i) {
                SearchSetting setting = searchableClassConverter.settings()[i];
                settings.setSetting(setting.name(), setting.value());
            }
            ((CompassConfigurable)((Object)converter)).configure(settings);
        }
        return converter;
    }

    private void bindObjectMapping(InternalObjectMapping objectMapping, String actualAccessor, String name, String annotationAccessor, Class<?> searchableClass) {
        if (!StringUtils.hasLength(annotationAccessor)) {
            objectMapping.setAccessor(actualAccessor);
        } else {
            objectMapping.setAccessor(annotationAccessor);
        }
        objectMapping.setName(name);
        objectMapping.setPropertyName(name);
        if (searchableClass.isAnnotationPresent(Searchable.class)) {
            Searchable searchable = searchableClass.getAnnotation(Searchable.class);
            objectMapping.setDefinedInAlias(this.getAliasFromSearchableClass(searchableClass, searchable));
        } else {
            objectMapping.setDefinedInAlias(ClassUtils.getShortName(searchableClass));
        }
    }

    private String[] getAliases(String commaSeparatedAliases) {
        ArrayList<String> aliases = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(commaSeparatedAliases, ",");
        while (st.hasMoreTokens()) {
            String extendedAlias = st.nextToken().trim();
            Alias alias = this.valueLookup.lookupAlias(extendedAlias);
            if (alias == null) {
                aliases.add(extendedAlias);
                continue;
            }
            aliases.add(alias.getName());
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    private void handleFormat(ClassPropertyMetaDataMapping mdMapping, String name, String format) {
        if (!StringUtils.hasLength(format)) {
            return;
        }
        if (mdMapping.getConverter() == null) {
            if (format == null) {
                format = this.valueLookup.lookupMetaDataFormat(name);
            }
            if (format != null) {
                mdMapping.setConverter(new FormatDelegateConverter(format));
            }
        }
    }
}

