/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.compass.core.asm.AnnotationVisitor;
import org.compass.core.asm.Type;
import org.compass.core.asm.commons.EmptyVisitor;
import org.compass.core.config.binding.metadata.ClassMetaData;
import org.compass.core.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmClassMetaData
extends EmptyVisitor
implements ClassMetaData {
    private String className;
    private boolean isInterface;
    private boolean isAbstract;
    private String enclosingClassName;
    private boolean independentInnerClass;
    private String superClassName;
    private String[] interfaces;
    private final Map<String, Map<String, Object>> attributesMap = new LinkedHashMap<String, Map<String, Object>>();
    private final Map<String, Set<String>> metaAnnotationMap = new LinkedHashMap<String, Set<String>>();

    @Override
    public void visit(int version, int access, String name, String signature, String supername, String[] interfaces) {
        this.className = ClassUtils.convertResourcePathToClassName(name);
        this.isInterface = (access & 0x200) != 0;
        boolean bl = this.isAbstract = (access & 0x400) != 0;
        if (supername != null) {
            this.superClassName = ClassUtils.convertResourcePathToClassName(supername);
        }
        this.interfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            this.interfaces[i] = ClassUtils.convertResourcePathToClassName(interfaces[i]);
        }
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.enclosingClassName = ClassUtils.convertResourcePathToClassName(owner);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (outerName != null && this.className.equals(ClassUtils.convertResourcePathToClassName(name))) {
            this.enclosingClassName = ClassUtils.convertResourcePathToClassName(outerName);
            this.independentInnerClass = (access & 8) != 0;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        final String className = Type.getType(desc).getClassName();
        final LinkedHashMap attributes = new LinkedHashMap();
        return new EmptyVisitor(){

            public void visit(String name, Object value) {
                attributes.put(name, value);
            }

            public void visitEnd() {
                try {
                    Method[] annotationAttributes;
                    Class<?> annotationClass = this.getClass().getClassLoader().loadClass(className);
                    for (Method annotationAttribute : annotationAttributes = annotationClass.getMethods()) {
                        String attributeName = annotationAttribute.getName();
                        Object defaultValue = annotationAttribute.getDefaultValue();
                        if (defaultValue == null || attributes.containsKey(attributeName)) continue;
                        attributes.put(attributeName, defaultValue);
                    }
                    Annotation[] metaAnnotations = annotationClass.getAnnotations();
                    HashSet<String> metaAnnotationTypeNames = new HashSet<String>();
                    for (Annotation metaAnnotation : metaAnnotations) {
                        metaAnnotationTypeNames.add(metaAnnotation.annotationType().getName());
                    }
                    AsmClassMetaData.this.metaAnnotationMap.put(className, metaAnnotationTypeNames);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                AsmClassMetaData.this.attributesMap.put(className, attributes);
            }
        };
    }

    @Override
    public Set<String> getAnnotationTypes() {
        return this.attributesMap.keySet();
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        return this.attributesMap.containsKey(annotationType);
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        return this.metaAnnotationMap.get(annotationType);
    }

    @Override
    public boolean hasMetaAnnotation(String metaAnnotationType) {
        Collection<Set<String>> allMetaTypes = this.metaAnnotationMap.values();
        for (Set<String> metaTypes : allMetaTypes) {
            if (!metaTypes.contains(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.attributesMap.get(annotationType);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isConcrete() {
        return !this.isInterface && !this.isAbstract;
    }

    @Override
    public boolean isIndependent() {
        return this.enclosingClassName == null || this.independentInnerClass;
    }

    @Override
    public boolean hasEnclosingClass() {
        return this.enclosingClassName != null;
    }

    @Override
    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public String[] getInterfaceNames() {
        return this.interfaces;
    }
}

