/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.core.mapping.InvalidMappingException;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.RefAliasObjectMapping;

public class ValidatorMappingProcessor
implements MappingProcessor {
    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        ResourceMapping[] rootMappings = compassMapping.getRootMappings();
        for (int i = 0; i < rootMappings.length; ++i) {
            ResourceMapping resourceMapping = rootMappings[i];
            this.validateRootMapping(resourceMapping);
        }
        return compassMapping;
    }

    private void validateRootMapping(ResourceMapping resourceMapping) throws MappingException {
        this.validatieHasAtLeastOneId(resourceMapping);
        this.validateMulitRefAliasHasPoly(resourceMapping);
        String[] resourcePropertyNames = resourceMapping.getResourcePropertyNames();
        for (int i = 0; i < resourcePropertyNames.length; ++i) {
            String propertyName = resourcePropertyNames[i];
            ResourcePropertyMapping[] resourcePropertyMapping = resourceMapping.getResourcePropertyMappings(propertyName);
            this.validateDuplicateExcludeFromAll(resourceMapping, propertyName, resourcePropertyMapping);
            this.validateDuplicateAnalyzer(resourceMapping, propertyName, resourcePropertyMapping);
        }
    }

    private void validatieHasAtLeastOneId(ResourceMapping resourceMapping) {
        Mapping[] idMappings = resourceMapping.getIdMappings();
        if (idMappings.length == 0) {
            throw new MappingException("Mapping for alias [" + resourceMapping.getAlias() + "] has no id mappings defined. " + "Either you forgot to add id mappings for it, or it is a component mapping that requires no ids and it " + "is not configured with root=false");
        }
    }

    private void validateMulitRefAliasHasPoly(ResourceMapping resourceMapping) {
        if (!(resourceMapping instanceof ClassMapping)) {
            return;
        }
        ClassMapping classMapping = (ClassMapping)resourceMapping;
        Iterator<Mapping> it = classMapping.mappingsIt();
        while (it.hasNext()) {
            ClassMapping[] refMappings;
            Mapping innerMapping = it.next();
            if (!(innerMapping instanceof RefAliasObjectMapping) || (refMappings = ((RefAliasObjectMapping)innerMapping).getRefClassMappings()).length <= 1) continue;
            for (int i = 0; i < refMappings.length; ++i) {
                if (refMappings[i].isPoly()) continue;
                throw new MappingException("Mapping for alias [" + classMapping.getAlias() + "] and reference/component mapping [" + innerMapping.getName() + "] has more than one ref-alias mappings, but class mapping [" + refMappings[i].getAlias() + "] is not defined as poly");
            }
        }
    }

    private void validateDuplicateExcludeFromAll(ResourceMapping resourceMapping, String propertyName, ResourcePropertyMapping[] resourcePropertyMapping) throws MappingException {
        if (resourcePropertyMapping.length == 1) {
            return;
        }
        ExcludeFromAll excludeFromAll = resourcePropertyMapping[0].getExcludeFromAll();
        for (int i = 1; i < resourcePropertyMapping.length; ++i) {
            if (resourcePropertyMapping[i].isInternal() || excludeFromAll == resourcePropertyMapping[i].getExcludeFromAll()) continue;
            throw new InvalidMappingException("Resource property / meta-data [" + propertyName + "] of alias [" + resourceMapping.getAlias() + "] has different exclude from all settings");
        }
    }

    private void validateDuplicateAnalyzer(ResourceMapping resourceMapping, String propertyName, ResourcePropertyMapping[] resourcePropertyMapping) throws MappingException {
        if (resourcePropertyMapping.length == 1) {
            return;
        }
        boolean first = true;
        String lastAnalyzer = null;
        for (int i = 0; i < resourcePropertyMapping.length; ++i) {
            ResourcePropertyMapping propertyMapping = resourcePropertyMapping[i];
            if (propertyMapping.isInternal()) continue;
            if (propertyMapping.getAnalyzer() != null) {
                if (lastAnalyzer == null && !first) {
                    throw new InvalidMappingException("Resource property / meta-data [" + propertyName + "] of alias [" + resourceMapping.getAlias() + "] has an anlyzer set, and some do not. Please set for all of them the same analyzer.");
                }
                if (first) {
                    lastAnalyzer = propertyMapping.getAnalyzer();
                } else if (!propertyMapping.getAnalyzer().equals(lastAnalyzer)) {
                    throw new InvalidMappingException("Resource property / meta-data [" + propertyName + "] of alias [" + resourceMapping.getAlias() + "] has several anlyzers set. Please set for all of them the same analyzer.");
                }
            } else if (lastAnalyzer != null) {
                throw new InvalidMappingException("Resource property / meta-data [" + propertyName + "] of alias [" + resourceMapping.getAlias() + "] has several anlyzers set. Please set for all of them the same analyzer.");
            }
            if (!first) continue;
            first = false;
        }
    }
}

