/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.executor.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.executor.spi.InternalExecutorManager;
import org.compass.core.util.concurrent.NamedThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledExecutorManager
implements InternalExecutorManager,
CompassConfigurable {
    private ScheduledExecutorService executorService;

    @Override
    public void configure(CompassSettings settings) throws CompassException {
        int corePoolSize = settings.getSettingAsInt("compass.executorManager.scheduled.corePoolSize", 10);
        this.executorService = Executors.newScheduledThreadPool(corePoolSize, new NamedThreadFactory("Compass Executor Thread", true));
    }

    @Override
    public void submit(Runnable task) {
        this.executorService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(tasks);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executorService.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

