/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.io.Reader;
import java.io.Serializable;
import org.compass.core.CompassException;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryBuilder;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.impl.DefaultCompassQuery;
import org.compass.core.mapping.ResourcePropertyLookup;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassQuery;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.spi.InternalCompassSpanQuery;

public class DefaultCompassQueryBuilder
implements CompassQueryBuilder {
    private final SearchEngineQueryBuilder queryBuilder;
    private final InternalCompass compass;
    private final InternalCompassSession session;
    private boolean convertOnlyWithDotPath = false;
    private boolean addAliasQueryIfNeeded = true;

    public DefaultCompassQueryBuilder(SearchEngineQueryBuilder queryBuilder, InternalCompass compass) {
        this(queryBuilder, compass, null);
    }

    public DefaultCompassQueryBuilder(SearchEngineQueryBuilder queryBuilder, InternalCompass compass, InternalCompassSession session) {
        this.queryBuilder = queryBuilder;
        this.compass = compass;
        this.session = session;
    }

    public CompassQueryBuilder convertOnlyWithDotPath(boolean convertOnlyWithDotPath) {
        this.convertOnlyWithDotPath = convertOnlyWithDotPath;
        return this;
    }

    public CompassQueryBuilder addAliasQueryIfNeeded(boolean addAliasQueryIfNeeded) {
        this.addAliasQueryIfNeeded = addAliasQueryIfNeeded;
        return this;
    }

    public CompassQueryBuilder.CompassBooleanQueryBuilder bool() {
        return new DefaultCompassBooleanQueryBuilder(this.queryBuilder.bool());
    }

    public CompassQueryBuilder.CompassBooleanQueryBuilder bool(boolean disableCoord) {
        return new DefaultCompassBooleanQueryBuilder(this.queryBuilder.bool(disableCoord));
    }

    public CompassQueryBuilder.CompassMultiPhraseQueryBuilder multiPhrase(String name) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        return new DefaultCompassMultiPhraseQueryBuilder(this.queryBuilder.multiPhrase(lookup.getPath()), lookup);
    }

    public CompassQueryBuilder.CompassQueryStringBuilder queryString(String queryString) {
        return new DefaultCompassQueryStringBuilder(this.queryBuilder.queryString(queryString));
    }

    public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder multiPropertyQueryString(String queryString) {
        return new DefaultCompassMultiPropertyQueryStringBuilder(this.queryBuilder.multiPropertyQueryString(queryString));
    }

    public CompassQuery alias(String aliasValue) {
        if (!this.compass.getMapping().hasRootMappingByAlias(aliasValue)) {
            throw new CompassException("Alias [" + aliasValue + "] not found in Compass mappings definitions");
        }
        String aliasProperty = this.compass.getSearchEngineFactory().getAliasProperty();
        SearchEngineQuery query = this.queryBuilder.term(aliasProperty, aliasValue);
        return this.buildCompassQuery(query);
    }

    public CompassQuery polyAlias(String aliasValue) {
        return this.bool().addShould(this.term(this.compass.getSearchEngineFactory().getAliasProperty(), aliasValue)).addShould(this.term(this.compass.getSearchEngineFactory().getExtendedAliasProperty(), aliasValue)).setMinimumNumberShouldMatch(1).toQuery();
    }

    public CompassQuery term(String name, Object value) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.term(lookup.getPath(), lookup.getValue(value));
        DefaultCompassQuery compassQuery = new DefaultCompassQuery(this.wrapWithAliasQueryIfNeeded(lookup, query), this.compass);
        this.attachIfPossible(compassQuery);
        return compassQuery;
    }

    public CompassQuery matchAll() {
        SearchEngineQuery query = this.queryBuilder.matchAll();
        return this.buildCompassQuery(query);
    }

    public CompassQuery between(String name, Object low, Object high, boolean inclusive, boolean constantScore) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.between(lookup.getPath(), lookup.getValue(low), lookup.getValue(high), inclusive, constantScore);
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery between(String name, Object low, Object high, boolean inclusive) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.between(lookup.getPath(), lookup.getValue(low), lookup.getValue(high), inclusive);
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery lt(String name, Object value) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.lt(lookup.getPath(), lookup.getValue(value));
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery le(String name, Object value) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.le(lookup.getPath(), lookup.getValue(value));
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery gt(String name, Object value) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.gt(lookup.getPath(), lookup.getValue(value));
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery ge(String name, Object value) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.ge(lookup.getPath(), lookup.getValue(value));
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery prefix(String name, String prefix) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.prefix(lookup.getPath(), prefix);
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery wildcard(String name, String wildcard) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.wildcard(lookup.getPath(), wildcard);
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery fuzzy(String name, String value, float minimumSimilarity) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value, minimumSimilarity);
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery fuzzy(String name, String value, float minimumSimilarity, int prefixLength) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value, minimumSimilarity, prefixLength);
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery fuzzy(String name, String value) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value);
        return this.buildCompassQuery(query, lookup);
    }

    public CompassQuery.CompassSpanQuery spanEq(String name, Object value) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanEq(lookup.getPath(), lookup.getValue(value));
        return this.buildCompassQuery(query);
    }

    public CompassQuery.CompassSpanQuery spanFirst(String name, Object value, int end) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanFirst(lookup.getPath(), lookup.getValue(value), end);
        return this.buildCompassQuery(query);
    }

    public CompassQuery.CompassSpanQuery spanFirst(CompassQuery.CompassSpanQuery spanQuery, int end) {
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanFirst(((DefaultCompassQuery.DefaultCompassSpanQuey)spanQuery).getSearchEngineSpanQuery(), end);
        return this.buildCompassQuery(query);
    }

    public CompassQueryBuilder.CompassQuerySpanNearBuilder spanNear(String name) {
        ResourcePropertyLookup lookup = this.getLookup(name);
        return new DefaultCompassQuerySpanNearBuilder(this.queryBuilder.spanNear(lookup.getPath()), lookup);
    }

    public CompassQuery.CompassSpanQuery spanNot(CompassQuery.CompassSpanQuery include, CompassQuery.CompassSpanQuery exclude) {
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanNot(((DefaultCompassQuery.DefaultCompassSpanQuey)include).getSearchEngineSpanQuery(), ((DefaultCompassQuery.DefaultCompassSpanQuey)exclude).getSearchEngineSpanQuery());
        return this.buildCompassQuery(query);
    }

    public CompassQueryBuilder.CompassQuerySpanOrBuilder spanOr() {
        return new DefaultCompassQuerySpanOrBuilder(this.queryBuilder.spanOr());
    }

    public CompassQueryBuilder.CompassMoreLikeThisQuery moreLikeThis(String alias, Serializable id) {
        if (this.session == null) {
            throw new CompassException("moreLikeThis query can only be used when constructed using a CompassSession");
        }
        Resource idResource = this.session.getMarshallingStrategy().marshallIds(alias, (Object)id);
        SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder mltQueryBuilder = this.queryBuilder.moreLikeThis(this.session.getSearchEngine(), idResource);
        return new DefaultCompassMoreLikeThisQuery(mltQueryBuilder, this.session);
    }

    public CompassQueryBuilder.CompassMoreLikeThisQuery moreLikeThis(Reader reader) {
        if (this.session == null) {
            throw new CompassException("moreLikeThis query can only be used when constructed using a CompassSession");
        }
        SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder mltQueryBuilder = this.queryBuilder.moreLikeThis(this.session.getSearchEngine(), reader);
        return new DefaultCompassMoreLikeThisQuery(mltQueryBuilder, this.session);
    }

    private InternalCompassSpanQuery buildCompassQuery(SearchEngineQuery.SearchEngineSpanQuery query) {
        DefaultCompassQuery.DefaultCompassSpanQuey compassSpanQuery = new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.compass);
        this.attachIfPossible(compassSpanQuery);
        return compassSpanQuery;
    }

    private InternalCompassQuery buildCompassQuery(SearchEngineQuery query, ResourcePropertyLookup lookup) {
        return this.buildCompassQuery(this.wrapWithAliasQueryIfNeeded(lookup, query));
    }

    private InternalCompassQuery buildCompassQuery(SearchEngineQuery query) {
        DefaultCompassQuery compassQuery = new DefaultCompassQuery(query, this.compass);
        this.attachIfPossible(compassQuery);
        return compassQuery;
    }

    private void attachIfPossible(InternalCompassQuery query) {
        if (this.session != null) {
            query.attach(this.session);
            this.session.addDelegateClose(query);
        }
    }

    private SearchEngineQuery wrapWithAliasQueryIfNeeded(ResourcePropertyLookup lookup, SearchEngineQuery query) {
        if (!this.addAliasQueryIfNeeded) {
            return query;
        }
        if (lookup == null) {
            return query;
        }
        String alias = lookup.getDotPathAlias();
        if (alias == null) {
            return query;
        }
        return this.queryBuilder.bool().addMust(query).addMust(this.queryBuilder.bool().addShould(this.queryBuilder.term(this.compass.getSearchEngineFactory().getAliasProperty(), alias)).addShould(this.queryBuilder.term(this.compass.getSearchEngineFactory().getExtendedAliasProperty(), alias)).setMinimumNumberShouldMatch(1).toQuery()).toQuery();
    }

    private ResourcePropertyLookup getLookup(String name) {
        ResourcePropertyLookup lookup = this.compass.getMapping().getResourcePropertyLookup(name);
        lookup.setConvertOnlyWithDotPath(this.convertOnlyWithDotPath);
        return lookup;
    }

    public class DefaultCompassMoreLikeThisQuery
    implements CompassQueryBuilder.CompassMoreLikeThisQuery {
        private SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassMoreLikeThisQuery(SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setSubIndexes(String[] subIndexes) {
            this.queryBuilder.setSubIndexes(subIndexes);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setAliases(String[] aliases) {
            this.queryBuilder.setAliases(aliases);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setProperties(String[] properties) {
            if (properties == null) {
                this.queryBuilder.setProperties(properties);
            } else {
                String[] updatedProperties = new String[properties.length];
                for (int i = 0; i < properties.length; ++i) {
                    ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(properties[i]);
                    updatedProperties[i] = lookup.getPath();
                }
                this.queryBuilder.setProperties(updatedProperties);
            }
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery addProperty(String property) {
            ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(property);
            this.queryBuilder.addProperty(lookup.getPath());
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setAnalyzer(String analyzer) {
            this.queryBuilder.setAnalyzer(analyzer);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setBoost(boolean boost) {
            this.queryBuilder.setBoost(boost);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMaxNumTokensParsed(int maxNumTokensParsed) {
            this.queryBuilder.setMaxNumTokensParsed(maxNumTokensParsed);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMaxQueryTerms(int maxQueryTerms) {
            this.queryBuilder.setMaxQueryTerms(maxQueryTerms);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMaxWordLen(int maxWordLen) {
            this.queryBuilder.setMaxWordLen(maxWordLen);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMinWordLen(int minWordLen) {
            this.queryBuilder.setMinWordLen(minWordLen);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMinResourceFreq(int minDocFreq) {
            this.queryBuilder.setMinResourceFreq(minDocFreq);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMinTermFreq(int minTermFreq) {
            this.queryBuilder.setMinTermFreq(minTermFreq);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setStopWords(String[] stopWords) {
            this.queryBuilder.setStopWords(stopWords);
            return this;
        }

        public CompassQuery toQuery() {
            return DefaultCompassQueryBuilder.this.buildCompassQuery(this.queryBuilder.toQuery());
        }
    }

    public class DefaultCompassQuerySpanOrBuilder
    implements CompassQueryBuilder.CompassQuerySpanOrBuilder {
        private SearchEngineQueryBuilder.SearchEngineQuerySpanOrBuilder queryBuilder;

        public DefaultCompassQuerySpanOrBuilder(SearchEngineQueryBuilder.SearchEngineQuerySpanOrBuilder queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public CompassQueryBuilder.CompassQuerySpanOrBuilder add(CompassQuery.CompassSpanQuery query) {
            this.queryBuilder.add(((DefaultCompassQuery.DefaultCompassSpanQuey)query).getSearchEngineSpanQuery());
            return this;
        }

        public CompassQuery.CompassSpanQuery toQuery() {
            SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.toQuery();
            return DefaultCompassQueryBuilder.this.buildCompassQuery(query);
        }
    }

    public class DefaultCompassQuerySpanNearBuilder
    implements CompassQueryBuilder.CompassQuerySpanNearBuilder {
        private SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder queryBuilder;
        private ResourcePropertyLookup lookup;

        public DefaultCompassQuerySpanNearBuilder(SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder queryBuilder, ResourcePropertyLookup lookup) {
            this.queryBuilder = queryBuilder;
            this.lookup = lookup;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder setSlop(int slop) {
            this.queryBuilder.setSlop(slop);
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder setInOrder(boolean inOrder) {
            this.queryBuilder.setInOrder(inOrder);
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder add(Object value) {
            this.queryBuilder.add(this.lookup.getValue(value));
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder add(CompassQuery.CompassSpanQuery query) {
            this.queryBuilder.add(((DefaultCompassQuery.DefaultCompassSpanQuey)query).getSearchEngineSpanQuery());
            return this;
        }

        public CompassQuery.CompassSpanQuery toQuery() {
            SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.toQuery();
            return DefaultCompassQueryBuilder.this.buildCompassQuery(query);
        }
    }

    public class DefaultCompassMultiPropertyQueryStringBuilder
    implements CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder {
        private SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder queryBuilder;

        public DefaultCompassMultiPropertyQueryStringBuilder(SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder setAnalyzer(String analyzer) throws CompassException {
            this.queryBuilder.setAnalyzer(analyzer);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder setAnalyzerByAlias(String alias) throws CompassException {
            this.queryBuilder.setAnalyzerByAlias(alias);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder setQueryParser(String queryParser) throws CompassException {
            this.queryBuilder.setQueryParser(queryParser);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder useSpellCheck() {
            this.queryBuilder.useSpellCheck();
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder add(String name) {
            this.queryBuilder.add(DefaultCompassQueryBuilder.this.compass.getMapping().getResourcePropertyLookup(name).getPath());
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder useAndDefaultOperator() {
            this.queryBuilder.useAndDefaultOperator();
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder useOrDefaultOperator() {
            this.queryBuilder.useOrDefaultOperator();
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder forceAnalyzer() {
            this.queryBuilder.forceAnalyzer();
            return this;
        }

        public CompassQuery toQuery() {
            return DefaultCompassQueryBuilder.this.buildCompassQuery(this.queryBuilder.toQuery());
        }
    }

    public class DefaultCompassQueryStringBuilder
    implements CompassQueryBuilder.CompassQueryStringBuilder {
        private SearchEngineQueryBuilder.SearchEngineQueryStringBuilder queryBuilder;

        public DefaultCompassQueryStringBuilder(SearchEngineQueryBuilder.SearchEngineQueryStringBuilder queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setAnalyzer(String analyzer) throws CompassException {
            this.queryBuilder.setAnalyzer(analyzer);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setAnalyzerByAlias(String alias) throws CompassException {
            this.queryBuilder.setAnalyzerByAlias(alias);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setQueryParser(String queryParser) throws CompassException {
            this.queryBuilder.setQueryParser(queryParser);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder useSpellCheck() throws CompassException {
            this.queryBuilder.useSpellCheck();
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setDefaultSearchProperty(String defaultSearchProperty) {
            this.queryBuilder.setDefaultSearchProperty(defaultSearchProperty);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder useAndDefaultOperator() {
            this.queryBuilder.useAndDefaultOperator();
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder useOrDefaultOperator() {
            this.queryBuilder.useOrDefaultOperator();
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder forceAnalyzer() {
            this.queryBuilder.forceAnalyzer();
            return this;
        }

        public CompassQuery toQuery() {
            return DefaultCompassQueryBuilder.this.buildCompassQuery(this.queryBuilder.toQuery());
        }
    }

    public class DefaultCompassMultiPhraseQueryBuilder
    implements CompassQueryBuilder.CompassMultiPhraseQueryBuilder {
        private SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder queryBuilder;
        private ResourcePropertyLookup lookup;

        public DefaultCompassMultiPhraseQueryBuilder(SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder queryBuilder, ResourcePropertyLookup lookup) {
            this.queryBuilder = queryBuilder;
            this.lookup = lookup;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder setSlop(int slop) {
            this.queryBuilder.setSlop(slop);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object value) {
            this.queryBuilder.add(this.lookup.getValue(value));
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object value, int position) {
            this.queryBuilder.add(this.lookup.getValue(value), position);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object[] values) {
            String[] strValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strValues[i] = this.lookup.getValue(values[i]);
            }
            this.queryBuilder.add(strValues);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object[] values, int position) {
            String[] strValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strValues[i] = this.lookup.getValue(values[i]);
            }
            this.queryBuilder.add(strValues, position);
            return this;
        }

        public CompassQuery toQuery() {
            return DefaultCompassQueryBuilder.this.buildCompassQuery(this.queryBuilder.toQuery());
        }
    }

    public class DefaultCompassBooleanQueryBuilder
    implements CompassQueryBuilder.CompassBooleanQueryBuilder {
        private SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder queryBuilder;

        public DefaultCompassBooleanQueryBuilder(SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addMust(CompassQuery query) {
            this.queryBuilder.addMust(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addMustNot(CompassQuery query) {
            this.queryBuilder.addMustNot(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addShould(CompassQuery query) {
            this.queryBuilder.addShould(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder setMinimumNumberShouldMatch(int min) {
            this.queryBuilder.setMinimumNumberShouldMatch(min);
            return this;
        }

        public CompassQuery toQuery() {
            return DefaultCompassQueryBuilder.this.buildCompassQuery(this.queryBuilder.toQuery());
        }
    }
}

