/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.all;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Token;
import org.compass.core.config.CompassSettings;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;

public class AllTermsCache {
    private final Map<String, Token[]> aliasTokensPerRootAlias = new HashMap<String, Token[]>();

    public AllTermsCache(CompassSettings settings, CompassMapping mapping) {
        for (ResourceMapping resourceMapping : mapping.getRootMappings()) {
            if (resourceMapping.getAllMapping().isExcludeAlias().booleanValue()) {
                this.aliasTokensPerRootAlias.put(resourceMapping.getAlias(), new Token[0]);
                continue;
            }
            ArrayList<Token> aliasTokens = new ArrayList<Token>();
            aliasTokens.add(new Token(resourceMapping.getAlias().toLowerCase(), 0, resourceMapping.getAlias().length()));
            for (String extendedAlias : resourceMapping.getExtendedAliases()) {
                aliasTokens.add(new Token(extendedAlias.toLowerCase(), 0, extendedAlias.length()));
            }
            this.aliasTokensPerRootAlias.put(resourceMapping.getAlias(), aliasTokens.toArray(new Token[aliasTokens.size()]));
        }
    }

    public Token[] getAliasTerms(String alias) {
        return this.aliasTokensPerRootAlias.get(alias);
    }
}

