/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.json.builder;

import org.compass.core.Property;
import org.compass.core.converter.Converter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.json.JsonContentMapping;

public class JsonContentMappingBuilder {
    final JsonContentMapping mapping = new JsonContentMapping();

    public JsonContentMappingBuilder(String name) {
        this.mapping.setName(name);
        this.mapping.setPath(new StaticPropertyPath(name));
        this.mapping.setInternal(true);
    }

    public JsonContentMappingBuilder store(Property.Store store) {
        if (store == Property.Store.NO) {
            throw new IllegalArgumentException("Content must be stored");
        }
        this.mapping.setStore(store);
        return this;
    }

    public JsonContentMappingBuilder converter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public JsonContentMappingBuilder converter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }
}

