/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.json.builder;

import org.compass.core.Property;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.json.JsonPropertyMapping;
import org.compass.core.mapping.json.Naming;

public class JsonPropertyMappingBuilder {
    final JsonPropertyMapping mapping = new JsonPropertyMapping();

    public JsonPropertyMappingBuilder(String name) {
        this.mapping.setName(name);
        if (name != null) {
            this.mapping.setPath(new StaticPropertyPath(name));
        }
    }

    public JsonPropertyMappingBuilder indexName(String indexName) {
        this.mapping.setPath(new StaticPropertyPath(indexName));
        return this;
    }

    public JsonPropertyMappingBuilder namingType(Naming namingType) {
        this.mapping.setNamingType(namingType);
        return this;
    }

    public JsonPropertyMappingBuilder store(Property.Store store) {
        this.mapping.setStore(store);
        return this;
    }

    public JsonPropertyMappingBuilder index(Property.Index index) {
        this.mapping.setIndex(index);
        return this;
    }

    public JsonPropertyMappingBuilder termVector(Property.TermVector termVector) {
        this.mapping.setTermVector(termVector);
        return this;
    }

    public JsonPropertyMappingBuilder omitNorms(boolean omitNorms) {
        this.mapping.setOmitNorms(omitNorms);
        return this;
    }

    public JsonPropertyMappingBuilder omitTf(boolean omitTf) {
        this.mapping.setOmitTf(omitTf);
        return this;
    }

    public JsonPropertyMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public JsonPropertyMappingBuilder format(String format) {
        this.mapping.setValueConverter(new FormatDelegateConverter(format));
        this.mapping.setFormat(format);
        return this;
    }

    public JsonPropertyMappingBuilder mappingConverter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public JsonPropertyMappingBuilder mappingConverter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public JsonPropertyMappingBuilder valueConverter(String converterName) {
        this.mapping.setValueConverterName(converterName);
        return this;
    }

    public JsonPropertyMappingBuilder valueConverter(Converter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public JsonPropertyMappingBuilder valueConverter(ResourcePropertyConverter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public JsonPropertyMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public JsonPropertyMappingBuilder excludeFromAll(ExcludeFromAll excludeFromAll) {
        this.mapping.setExcludeFromAll(excludeFromAll);
        return this;
    }

    public JsonPropertyMappingBuilder nullValue(String nullValue) {
        this.mapping.setNullValue(nullValue);
        return this;
    }

    public JsonPropertyMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }
}

