/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.rsem.builder;

import org.compass.core.Property;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.rsem.RawResourcePropertyMapping;

public class ResourcePropertyMappingBuilder {
    final RawResourcePropertyMapping mapping = new RawResourcePropertyMapping();

    public ResourcePropertyMappingBuilder(String name) {
        this.mapping.setName(name);
        this.mapping.setPath(new StaticPropertyPath(name));
    }

    public ResourcePropertyMappingBuilder store(Property.Store store) {
        this.mapping.setStore(store);
        return this;
    }

    public ResourcePropertyMappingBuilder index(Property.Index index) {
        this.mapping.setIndex(index);
        return this;
    }

    public ResourcePropertyMappingBuilder termVector(Property.TermVector termVector) {
        this.mapping.setTermVector(termVector);
        return this;
    }

    public ResourcePropertyMappingBuilder omitNorms(boolean omitNorms) {
        this.mapping.setOmitNorms(omitNorms);
        return this;
    }

    public ResourcePropertyMappingBuilder omitTf(boolean omitTf) {
        this.mapping.setOmitTf(omitTf);
        return this;
    }

    public ResourcePropertyMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public ResourcePropertyMappingBuilder format(String format) {
        this.mapping.setConverter(new FormatDelegateConverter(format));
        return this;
    }

    public ResourcePropertyMappingBuilder converter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public ResourcePropertyMappingBuilder converter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public ResourcePropertyMappingBuilder converter(ResourcePropertyConverter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public ResourcePropertyMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public ResourcePropertyMappingBuilder excludeFromAll(ExcludeFromAll excludeFromAll) {
        this.mapping.setExcludeFromAll(excludeFromAll);
        return this;
    }

    public ResourcePropertyMappingBuilder nullValue(String nullValue) {
        this.mapping.setNullValue(nullValue);
        return this;
    }

    public ResourcePropertyMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }
}

