/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.lifecycle;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.Synchronization;
import org.compass.core.CompassSession;
import org.compass.core.mapping.Cascade;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.core.util.Assert;
import org.compass.core.util.FieldInvoker;
import org.compass.gps.spi.CompassGpsInterfaceDevice;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateEventListenerUtils {
    public static void registerRemovalHook(EventSource eventSource, Map<Object, Collection> pendingMap, Object entity) {
        eventSource.getTransaction().registerSynchronization((Synchronization)new RemoveFromPending(pendingMap, entity));
    }

    public static Collection getAssociatedDependencies(Object entity, Map<Object, Collection> pendingMap) {
        HashSet dependencies = new HashSet();
        for (Collection other : pendingMap.values()) {
            if (!other.contains(entity)) continue;
            dependencies.addAll(other);
        }
        return dependencies;
    }

    public static Collection getUnpersistedCascades(CompassGpsInterfaceDevice compassGps, Object entity, SessionFactoryImplementor sessionFactory, Cascade cascade, Collection visited) {
        if (visited.contains(entity)) {
            return Collections.EMPTY_SET;
        }
        visited.add(entity);
        ClassMetadata classMetadata = sessionFactory.getClassMetadata(entity.getClass());
        if (classMetadata == null) {
            for (ClassMetadata temp : sessionFactory.getAllClassMetadata().values()) {
                if (!entity.getClass().equals(temp.getMappedClass(EntityMode.POJO))) continue;
                classMetadata = temp;
                break;
            }
        }
        Assert.notNull(classMetadata, "Failed to lookup Hibernate ClassMetadata for entity [" + entity + "]");
        String entityName = classMetadata.getEntityName();
        EntityPersister persister = sessionFactory.getEntityPersister(entityName);
        CompassMapping compassMapping = ((InternalCompass)compassGps.getIndexCompass()).getMapping();
        ClassMapping classMapping = (ClassMapping)compassMapping.getMappingByClass(entity.getClass());
        if (classMapping == null) {
            return Collections.EMPTY_SET;
        }
        String[] propertyNames = persister.getPropertyNames();
        Type[] types = persister.getPropertyTypes();
        HashSet<Object> dependencies = new HashSet<Object>();
        int len = propertyNames.length;
        for (int i = 0; i < len; ++i) {
            Class propertyType;
            Object propertyValue;
            String name = propertyNames[i];
            Mapping mapping = classMapping.getMapping(name);
            if (mapping == null || (propertyValue = persister.getPropertyValue(entity, name, EntityMode.POJO)) == null) continue;
            Type type = types[i];
            boolean collection = false;
            if (type instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)type;
                propertyType = persister.getFactory().getCollectionPersister(collectionType.getRole()).getElementType().getReturnedClass();
                collection = true;
            } else {
                propertyType = type.getReturnedClass();
            }
            if (!compassGps.hasMappingForEntityForMirror(propertyType, cascade)) continue;
            ResourceMapping propertyTypeMapping = compassMapping.getMappingByClass(propertyType);
            Mapping[] idMappings = propertyTypeMapping.getIdMappings();
            int jlen = idMappings.length;
            for (int j = 0; j < jlen; ++j) {
                ClassPropertyMetaDataMapping idMapping = (ClassPropertyMetaDataMapping)idMappings[j];
                String idPropertyName = idMapping.getPropertyName();
                try {
                    FieldInvoker idGetter = new FieldInvoker(propertyType, idPropertyName).prepare();
                    Object value = new FieldInvoker(entity.getClass(), name).prepare().get(entity);
                    if (collection) {
                        for (Object obj : (Collection)value) {
                            Object id = idGetter.get(obj);
                            if (id == null) {
                                dependencies.add(obj);
                            }
                            dependencies.addAll(HibernateEventListenerUtils.getUnpersistedCascades(compassGps, obj, sessionFactory, cascade, visited));
                        }
                        continue;
                    }
                    Object id = idGetter.get(value);
                    if (id == null) {
                        dependencies.add(value);
                    }
                    dependencies.addAll(HibernateEventListenerUtils.getUnpersistedCascades(compassGps, value, sessionFactory, cascade, visited));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return dependencies;
    }

    public static void persistPending(CompassSession session, Object entity, Map<Object, Collection> pendingMap, boolean create) {
        Iterator<Object> iter = pendingMap.keySet().iterator();
        while (iter.hasNext()) {
            Object pending = iter.next();
            Collection dependencies = pendingMap.get(pending);
            if (!dependencies.remove(entity) || !dependencies.isEmpty()) continue;
            if (create) {
                session.create(pending);
            } else {
                session.save(pending);
            }
            iter.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveFromPending
    implements Synchronization {
        private Map<Object, Collection> pendingMap;
        private Object entity;

        public RemoveFromPending(Map<Object, Collection> pendingMap, Object entity) {
            this.pendingMap = pendingMap;
            this.entity = entity;
        }

        private void removePendingDependencies(Object entity, Map<Object, Collection> pendingMap) {
            Iterator<Object> iter = pendingMap.keySet().iterator();
            while (iter.hasNext()) {
                Object pending = iter.next();
                if (pending == entity) {
                    iter.remove();
                    break;
                }
                Collection dependencies = pendingMap.get(pending);
                dependencies.remove(entity);
                if (!dependencies.isEmpty()) continue;
                iter.remove();
            }
        }

        public void afterCompletion(int i) {
            this.removePendingDependencies(this.entity, this.pendingMap);
        }

        public void beforeCompletion() {
        }
    }
}

