/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.lifecycle;

import javax.persistence.EntityManagerFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.extractor.NativeJpaHelper;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjector;

public abstract class JpaEntityLifecycleInjectorDetector {
    public static JpaEntityLifecycleInjector detectInjector(EntityManagerFactory entityManagerFactory, final CompassSettings settings) throws JpaGpsDeviceException {
        String injectorClassName = NativeJpaHelper.detectNativeJpa(entityManagerFactory, new NativeJpaHelper.NativeJpaCallback<String>(){

            @Override
            public String onHibernate() {
                try {
                    ClassUtils.forName("org.hibernate.event.AbstractCollectionEvent", settings.getClassLoader());
                    return "org.compass.gps.device.jpa.lifecycle.HibernateJpaEntityCollectionLifecycleInjector";
                }
                catch (ClassNotFoundException e) {
                    return "org.compass.gps.device.jpa.lifecycle.HibernateJpaEntityLifecycleInjector";
                }
            }

            @Override
            public String onTopLinkEssentials() {
                return "org.compass.gps.device.jpa.lifecycle.TopLinkEssentialsJpaEntityLifecycleInjector";
            }

            @Override
            public String onEclipseLink() {
                return "org.compass.gps.device.jpa.lifecycle.EclipseLinkJpaEntityLifecycleInjector";
            }

            @Override
            public String onOpenJPA() {
                return "org.compass.gps.device.jpa.lifecycle.OpenJPAJpaEntityLifecycleInjector";
            }

            @Override
            public String onUnknown() {
                return null;
            }
        });
        if (injectorClassName == null) {
            return null;
        }
        try {
            Class injectorClass = ClassUtils.forName(injectorClassName, settings.getClassLoader());
            return (JpaEntityLifecycleInjector)injectorClass.newInstance();
        }
        catch (Exception e) {
            throw new JpaGpsDeviceException("Failed to create injector class [" + injectorClassName + "]", e);
        }
    }
}

