/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.terracotta.TerracottaDirectory;
import org.compass.needle.terracotta.TerracottaFile;

public class FlushOnCloseTerracottaIndexOutput
extends IndexOutput {
    private final TerracottaDirectory dir;
    private final int bufferSize;
    private final String name;
    private TerracottaFile file;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;
    private boolean open;

    FlushOnCloseTerracottaIndexOutput(TerracottaDirectory dir, String name) throws IOException {
        this.dir = dir;
        this.name = name;
        this.bufferSize = dir.getBufferSize();
        this.file = new TerracottaFile();
        dir.addFile(name, TerracottaDirectory.EMPTY_FILE);
        this.open = true;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        this.currentBuffer[this.bufferPosition++] = b;
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.currentBuffer.length - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b, offset, this.currentBuffer, this.bufferPosition, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    public void flush() throws IOException {
        this.setFileLength();
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.flush();
        this.file.setLastModified(System.currentTimeMillis());
        this.dir.addFile(this.name, this.file);
        this.currentBuffer = null;
    }

    public long length() {
        return this.file.getLength();
    }

    public void seek(long pos) throws IOException {
        this.setFileLength();
        if (pos < this.bufferStart || pos >= this.bufferStart + (long)this.bufferLength) {
            this.currentBufferIndex = (int)(pos / (long)this.bufferSize);
            this.switchCurrentBuffer();
        }
        this.bufferPosition = (int)(pos % (long)this.bufferSize);
    }

    private void switchCurrentBuffer() throws IOException {
        this.currentBuffer = this.currentBufferIndex == this.file.getNumBuffers() ? this.file.addBuffer(this.bufferSize) : this.file.getBuffer(this.currentBufferIndex);
        this.bufferPosition = 0;
        this.bufferStart = (long)this.bufferSize * (long)this.currentBufferIndex;
        this.bufferLength = this.currentBuffer.length;
    }

    private void setFileLength() {
        long pointer = this.bufferStart + (long)this.bufferPosition;
        if (pointer > this.file.length) {
            this.file.setLength(pointer);
        }
    }
}

