/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.lucene.store.Lock;
import org.compass.needle.terracotta.ManagedTerracottaLockAdapter;
import org.compass.needle.terracotta.TerracottaDirectory;
import org.compass.needle.terracotta.TerracottaFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedTerracottaDirectory
extends TerracottaDirectory {
    private final ReadWriteLock rwl;

    public ManagedTerracottaDirectory(ReadWriteLock rwl) {
        this.rwl = rwl;
    }

    public ManagedTerracottaDirectory(ReadWriteLock rwl, int bufferSize, int flushRate) {
        super(bufferSize, flushRate);
        this.rwl = rwl;
    }

    public ManagedTerracottaDirectory(ReadWriteLock rwl, int bufferSize, int flushRate, int chmInitialCapacity, float chmLoadFactor, int chmConcurrencyLevel) {
        super(bufferSize, flushRate, chmInitialCapacity, chmLoadFactor, chmConcurrencyLevel);
        this.rwl = rwl;
    }

    @Override
    protected Map<String, TerracottaFile> createMap(int chmInitialCapacity, float chmLoadFactor, int chmConcurrencyLevel) {
        return new HashMap<String, TerracottaFile>(chmInitialCapacity, chmLoadFactor);
    }

    public Lock makeLock(String name) {
        return new ManagedTerracottaLockAdapter(this.rwl, super.makeLock(name));
    }

    @Override
    public void deleteFile(final String name) throws IOException {
        this.doWithWriteLock(new WriteLockTask<Object>(){

            @Override
            public Object execute() throws IOException {
                ManagedTerracottaDirectory.super.deleteFile(name);
                return null;
            }
        });
    }

    @Override
    public void renameFile(final String from, final String to) throws IOException {
        this.doWithWriteLock(new WriteLockTask<Object>(){

            @Override
            public Object execute() throws IOException {
                ManagedTerracottaDirectory.super.renameFile(from, to);
                return null;
            }
        });
    }

    @Override
    void addFile(final String name, final TerracottaFile file) throws IOException {
        this.doWithWriteLock(new WriteLockTask<Object>(){

            @Override
            public Object execute() throws IOException {
                ManagedTerracottaDirectory.super.addFile(name, file);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doWithWriteLock(WriteLockTask<T> task) throws IOException {
        boolean unlocked;
        try {
            this.rwl.readLock().unlock();
            unlocked = true;
        }
        catch (IllegalMonitorStateException e) {
            unlocked = false;
        }
        this.rwl.writeLock().lock();
        try {
            T t = task.execute();
            return t;
        }
        finally {
            if (unlocked) {
                this.rwl.readLock().lock();
            }
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface WriteLockTask<T> {
        public T execute() throws IOException;
    }
}

