/*
 * Decompiled with CFR 0.152.
 */
package org.compevol.amh11;

import java.util.Arrays;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import org.compevol.amh11.HT00;
import org.compevol.amh11.ThetaTaylor;
import org.compevol.amh11.Utils;

public final class AMH11 {
    private static final double TOL = Math.pow(2.0, -53.0);

    private AMH11() {
    }

    public static double[] expmv(double d, double[][] dArray, double[] dArray2) {
        return Matrices.getArray((Vector)AMH11.expmv(d, (Matrix)new DenseMatrix(dArray), (Vector)new DenseVector(dArray2), null, true, false, true, false, false));
    }

    public static Vector expmv(double d, Matrix matrix, Vector vector) {
        return AMH11.expmv(d, matrix, vector, null, true, false, true, true, false);
    }

    public static Vector expmv(double d, Matrix matrix, Vector vector, Matrix matrix2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n;
        double d2;
        if (bl4) {
            matrix = matrix.copy();
            vector = vector.copy();
        }
        if (bl2) {
            throw new RuntimeException("Not implemented!");
        }
        int n2 = matrix.numRows();
        double d3 = 0.0;
        if (bl) {
            d3 = Utils.trace(matrix) / (double)n2;
            matrix.add(-1.0, Matrices.identity((int)n2).scale(d3));
        }
        if (matrix2 == null) {
            d2 = 1.0;
            matrix2 = AMH11.selectTaylorDegree(matrix.copy().scale(d), vector, 55, 8, bl, bl2, false, bl5);
        } else {
            d2 = d;
        }
        double d4 = 1.0;
        if (d == 0.0) {
            n = 0;
        } else {
            int n3 = matrix2.numRows();
            Matrix matrix3 = Utils.ascendingDiagonal(n3);
            Matrix matrix4 = Utils.ceil(matrix2.scale(Math.abs(d2))).transAmult(matrix3, (Matrix)new DenseMatrix(matrix2.numColumns(), matrix3.numColumns()));
            Utils.Zero2Inf(matrix4);
            int[] nArray = new int[2];
            double d5 = AMH11.getMin(matrix4, nArray);
            n = nArray[matrix4.numColumns() > 1 ? 1 : 0] + 1;
            if (d5 == Double.POSITIVE_INFINITY) {
                d5 = 0.0;
            }
            d4 = Math.max(d5 / (double)n, 1.0);
        }
        double d6 = 1.0;
        if (bl) {
            d6 = Math.exp(d * d3 / d4);
        }
        Vector vector2 = vector.copy();
        int n4 = 0;
        while ((double)n4 < d4) {
            double d7 = vector.norm(Vector.Norm.Infinity);
            for (int i = 1; i <= n; ++i) {
                vector = matrix.mult(vector, (Vector)new DenseVector(vector.size())).scale(d / (d4 * (double)i));
                vector2.add(vector);
                double d8 = vector.norm(Vector.Norm.Infinity);
                if (bl3) continue;
                if (d7 + d8 <= TOL * vector2.norm(Vector.Norm.Infinity)) break;
                d7 = d8;
            }
            vector = vector2.scale(d6);
            ++n4;
        }
        return vector2;
    }

    private static double getMin(Matrix matrix, int[] nArray) {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < matrix.numRows(); ++i) {
            for (int j = 0; j < matrix.numColumns(); ++j) {
                double d2 = matrix.get(i, j);
                if (!(d2 < d)) continue;
                d = d2;
                nArray[0] = i;
                nArray[1] = j;
            }
        }
        return d;
    }

    public static Matrix selectTaylorDegree(Matrix matrix, Vector vector, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n3;
        Object object;
        double[] dArray;
        int n4 = matrix.numRows();
        if (bl2) {
            throw new RuntimeException("Not implemented!");
        }
        if (bl) {
            double d = Utils.trace(matrix) / (double)n4;
            matrix.add(-d, (Matrix)Matrices.identity((int)n4));
        }
        double d = 0.0;
        double d2 = 0.0;
        if (!bl3) {
            d2 = matrix.norm(Matrix.Norm.One);
        }
        if (!bl3 && d2 < 4.0 * ThetaTaylor.THETA[n] * (double)n2 * (double)(n2 + 3) / (double)(n * vector.size())) {
            dArray = new double[n2 - 1];
            Arrays.fill(dArray, d2);
        } else {
            object = new double[n2];
            dArray = new double[n2 - 1];
            for (n3 = 0; n3 < n2; ++n3) {
                double[] dArray2 = AMH11.normAm(matrix, n3 + 2, bl4);
                double d3 = Math.pow(dArray2[0], 1.0 / (double)(n3 + 2));
                d += dArray2[1];
                object[n3] = d3;
            }
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                dArray[n3] = Math.max(object[n3], object[n3 + 1]);
            }
        }
        object = new DenseMatrix(n, n2 - 1);
        for (n3 = 2; n3 <= n2; ++n3) {
            for (int i = n3 * (n3 - 1) - 1; i <= n; ++i) {
                object.set(i - 1, n3 - 2, dArray[n3 - 2] / ThetaTaylor.THETA[i - 1]);
            }
        }
        return object;
    }

    private static double[] normAm(final Matrix matrix, final int n, boolean bl) {
        double d;
        double d2;
        int n2 = 1;
        final int n3 = matrix.numColumns();
        if (bl || Utils.isPositive(matrix)) {
            Vector vector = Utils.fill((Vector)new DenseVector(n3), 1.0);
            for (int i = 0; i < n; ++i) {
                vector = matrix.transMult(vector, (Vector)new DenseVector(n3));
            }
            d2 = vector.norm(Vector.Norm.Infinity);
            d = n;
        } else {
            Utils.MatrixFunction matrixFunction = new Utils.MatrixFunction(){

                @Override
                public Matrix apply(Matrix matrix2, boolean bl) {
                    if (!bl) {
                        for (int i = 0; i < n; ++i) {
                            matrix2 = matrix.mult(matrix2, (Matrix)new DenseMatrix(matrix.numRows(), matrix2.numColumns()));
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            matrix2 = matrix.transAmult(matrix2, (Matrix)new DenseMatrix(matrix.numColumns(), matrix2.numColumns()));
                        }
                    }
                    return matrix2;
                }

                @Override
                public int getDimensions() {
                    return n3;
                }

                @Override
                public boolean isReal() {
                    return true;
                }
            };
            double[] dArray = HT00.normest1(matrixFunction, n2);
            d2 = dArray[0];
            d = dArray[1] * (double)n2 * (double)n;
        }
        return new double[]{d2, d};
    }
}

