/*
 * Decompiled with CFR 0.152.
 */
package org.compevol.amh11;

import java.util.Random;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;

public final class Utils {
    private static AMH11Random random = new AMH11Random(){
        private final Random random = new Random();

        @Override
        public boolean nextBoolean() {
            return this.random.nextBoolean();
        }
    };

    private Utils() {
    }

    public static void setRandom(AMH11Random aMH11Random) {
        random = aMH11Random;
    }

    public static Vector fill(Vector vector, double d) {
        for (int i = 0; i < vector.size(); ++i) {
            vector.set(i, d);
        }
        return vector;
    }

    public static double trace(Matrix matrix) {
        double d = 0.0;
        for (int i = 0; i < matrix.numRows(); ++i) {
            d += matrix.get(i, i);
        }
        return d;
    }

    public static Matrix ascendingDiagonal(int n) {
        DenseMatrix denseMatrix = new DenseMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            denseMatrix.set(i, i, (double)(i + 1));
        }
        return denseMatrix;
    }

    public static Matrix ceil(Matrix matrix) {
        for (MatrixEntry matrixEntry : matrix) {
            matrixEntry.set(Math.ceil(matrixEntry.get()));
        }
        return matrix;
    }

    public static Matrix abs(Matrix matrix) {
        for (MatrixEntry matrixEntry : matrix) {
            matrixEntry.set(Math.abs(matrixEntry.get()));
        }
        return matrix;
    }

    public static Matrix Zero2Inf(Matrix matrix) {
        for (int i = 0; i < matrix.numRows(); ++i) {
            for (int j = 0; j < matrix.numColumns(); ++j) {
                if (matrix.get(i, j) != 0.0) continue;
                matrix.set(i, j, Double.POSITIVE_INFINITY);
            }
        }
        return matrix;
    }

    public static boolean isPositive(Matrix matrix) {
        for (MatrixEntry matrixEntry : matrix) {
            if (!(matrixEntry.get() < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static double entrySum(Vector vector) {
        double d = 0.0;
        for (VectorEntry vectorEntry : vector) {
            d += vectorEntry.get();
        }
        return d;
    }

    public static Vector rowAsVector(Matrix matrix, int n) {
        DenseVector denseVector = new DenseVector(matrix.numColumns());
        for (int i = 0; i < matrix.numColumns(); ++i) {
            denseVector.set(i, matrix.get(n, i));
        }
        return denseVector;
    }

    public static Vector columnAsVector(Matrix matrix, int n) {
        DenseVector denseVector = new DenseVector(matrix.numRows());
        for (int i = 0; i < matrix.numColumns(); ++i) {
            denseVector.set(i, matrix.get(i, n));
        }
        return denseVector;
    }

    public static Vector absColumnSums(Matrix matrix) {
        DenseVector denseVector = new DenseVector(matrix.numColumns());
        for (int i = 0; i < matrix.numColumns(); ++i) {
            double d = Utils.columnAsVector(matrix, i).norm(Vector.Norm.One);
            denseVector.set(i, d);
        }
        return denseVector;
    }

    public static Matrix randomSigns(int n, int n2) {
        DenseMatrix denseMatrix = new DenseMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = random.nextBoolean() ? 1.0 : -1.0;
                denseMatrix.set(i, j, d);
            }
        }
        return denseMatrix;
    }

    public static Vector columnsMax(Matrix matrix) {
        DenseVector denseVector = new DenseVector(matrix.numColumns());
        for (int i = 0; i < denseVector.size(); ++i) {
            denseVector.set(i, Utils.columnAsVector(matrix, i).norm(Vector.Norm.Infinity));
        }
        return denseVector;
    }

    public static int memberCount(int[] nArray, Vector vector) {
        int n = 0;
        for (int n2 : nArray) {
            if (!Utils.contains(vector, n2)) continue;
            ++n;
        }
        return n;
    }

    public static boolean contains(Vector vector, double d) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) != d) continue;
            return true;
        }
        return false;
    }

    public static Matrix createSubMatrix(Matrix matrix, int n, int n2, int n3, int n4) {
        DenseMatrix denseMatrix = new DenseMatrix(n3, n4);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                denseMatrix.set(i, j, matrix.get(n + i, n2 + j));
            }
        }
        return denseMatrix;
    }

    public static interface AMH11Random {
        public boolean nextBoolean();
    }

    public static interface MatrixFunction {
        public Matrix apply(Matrix var1, boolean var2);

        public int getDimensions();

        public boolean isReal();
    }
}

