/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.nio.file.Path;
import java.util.Locale;
import javafx.util.Builder;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.robot.IRobot;

public class KeyBoardBuilder
implements Builder<KeyboardPane> {
    private final KeyboardPane kb = new KeyboardPane();

    protected KeyBoardBuilder() {
    }

    public static KeyBoardBuilder create() {
        return new KeyBoardBuilder();
    }

    public void layerPath(Path path) {
        this.kb.setLayerPath(path);
    }

    public void layer(DefaultLayer layer) {
        this.kb.setLayer(layer);
    }

    public void style(String css) {
        this.kb.setStyle(css);
    }

    public void initLocale(Locale locale) {
        this.kb.setLocale(locale);
    }

    public void initScale(double scale) {
        this.kb.setScale(scale);
    }

    public void addIRobot(IRobot robot) {
        this.kb.addRobotHandler(robot);
    }

    public KeyboardPane build() {
        try {
            this.kb.load();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.kb;
    }
}

