/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javafx.animation.FadeTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.MouseEvent;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.comtel2000.keyboard.FXOK;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.control.KeyboardType;

public class KeyBoardPopup
extends Popup {
    public static final EventHandler<? super Event> DEFAULT_CLOSE_HANDLER = event -> {
        if (event.getSource() instanceof Node) {
            ((Node)event.getSource()).fireEvent((Event)new WindowEvent(null, WindowEvent.WINDOW_CLOSE_REQUEST));
        }
    };
    private static final String STYLE_CSS = "/css/KeyboardTextInputSkin.css";
    private final KeyboardPane keyboard;
    private boolean doNotOpenHiddenKeyboard = false;
    private final ChangeListener<? super Node> focusChangeListener = (value, n1, n2) -> {
        TextInputControl control;
        if (n2 instanceof TextInputControl) {
            this.setVisible(this.doNotOpenHiddenKeyboard ? Visibility.POS : Visibility.SHOW, (TextInputControl)n2);
            return;
        }
        if (n2 instanceof Parent && (control = KeyBoardPopup.findTextInputControl((Parent)n2)) != null) {
            this.setVisible(this.doNotOpenHiddenKeyboard ? Visibility.POS : Visibility.SHOW, control);
            return;
        }
        this.setVisible(Visibility.HIDE);
    };
    private final EventHandler<? super MouseEvent> doubleClickEventFilter = event -> {
        Node node;
        if (event.getClickCount() == 2 && event.getSource() instanceof Stage && (node = ((Stage)event.getSource()).getScene().getFocusOwner()) instanceof TextInputControl) {
            this.setVisible(Visibility.SHOW, (TextInputControl)node);
        }
    };
    private Scene owner;
    private double offsetValue = 5.0;
    private DoubleProperty offset;
    private FadeTransition animation;

    public KeyBoardPopup(KeyboardPane panel) {
        this.keyboard = Objects.requireNonNull(panel);
        this.getContent().add((Object)this.keyboard);
    }

    public static String getUserAgentStyleSheet() {
        return KeyBoardPopup.class.getResource(STYLE_CSS).toExternalForm();
    }

    private static TextInputControl findTextInputControl(Parent parent) {
        for (Node child : parent.getChildrenUnmodifiable()) {
            if (!(child instanceof TextInputControl)) continue;
            return (TextInputControl)child;
        }
        return null;
    }

    public final KeyboardPane getKeyBoard() {
        return this.keyboard;
    }

    public boolean isVisible() {
        return this.isShowing();
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible ? Visibility.SHOW : Visibility.HIDE);
    }

    void setVisible(Visibility visible) {
        this.setVisible(visible, null);
    }

    public Scene getRegisteredScene() {
        return this.owner;
    }

    public void registerScene(Scene scene) {
        this.owner = Objects.requireNonNull(scene);
    }

    public void addFocusListener(Scene scene) {
        this.addFocusListener(scene, false);
    }

    public void addFocusListener(Scene scene, boolean doNotOpen) {
        this.doNotOpenHiddenKeyboard = doNotOpen;
        this.registerScene(scene);
        scene.focusOwnerProperty().addListener(this.focusChangeListener);
    }

    public void addGlobalFocusListener() {
        this.addGlobalFocusListener(this.doNotOpenHiddenKeyboard);
    }

    public void addGlobalFocusListener(boolean doNotOpen) {
        this.doNotOpenHiddenKeyboard = doNotOpen;
        Window.getWindows().addListener(c -> {
            while (c.next()) {
                if (c.wasPermutated()) continue;
                c.getAddedSubList().forEach(win -> win.getScene().focusOwnerProperty().addListener(this.focusChangeListener));
                c.getRemoved().forEach(win -> win.getScene().focusOwnerProperty().removeListener(this.focusChangeListener));
            }
        });
    }

    public void addDoubleClickEventFilter(Stage stage) {
        stage.addEventFilter(MouseEvent.MOUSE_CLICKED, this.doubleClickEventFilter);
    }

    public void addGlobalDoubleClickEventFilter() {
        Window.getWindows().addListener(c -> {
            while (c.next()) {
                if (c.wasPermutated()) continue;
                c.getAddedSubList().forEach(win -> win.addEventFilter(MouseEvent.MOUSE_CLICKED, this.doubleClickEventFilter));
                c.getRemoved().forEach(win -> win.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.doubleClickEventFilter));
            }
        });
    }

    public void setOnKeyboardCloseButton(EventHandler<? super Event> value) {
        this.getKeyBoard().setOnKeyboardCloseButton(value);
    }

    public void setVisible(Visibility visible, TextInputControl textNode) {
        if ((visible == Visibility.POS || visible == Visibility.SHOW) && textNode != null) {
            Map<String, String> vkProps = FXOK.getVkProperties((Node)textNode);
            if (vkProps.isEmpty()) {
                this.getKeyBoard().setKeyboardType(KeyboardType.TEXT);
            } else {
                if ("off".equals(vkProps.get("vkState"))) {
                    this.startFade(Visibility.HIDE, textNode);
                    return;
                }
                this.getKeyBoard().setKeyboardType(vkProps.getOrDefault("vkType", "text"));
                if (vkProps.containsKey("vkLocale")) {
                    this.getKeyBoard().switchLocale(new Locale(vkProps.get("vkLocale")));
                }
            }
            Bounds textNodeBounds = textNode.localToScreen(textNode.getBoundsInLocal());
            Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
            if (textNodeBounds.getMinX() + this.getWidth() > screenBounds.getMaxX()) {
                this.setX(screenBounds.getMaxX() - this.getWidth());
            } else {
                this.setX(textNodeBounds.getMinX());
            }
            if (textNodeBounds.getMaxY() + this.getHeight() > screenBounds.getMaxY()) {
                this.setY(textNodeBounds.getMinY() - this.getHeight() - this.getOffset());
            } else {
                this.setY(textNodeBounds.getMaxY() + this.getOffset());
            }
        }
        this.startFade(visible, textNode);
    }

    private void startFade(Visibility visible, TextInputControl textNode) {
        if (visible == Visibility.POS || visible == Visibility.HIDE && !this.isShowing()) {
            return;
        }
        if (this.animation != null) {
            this.animation.stop();
        } else {
            this.animation = new FadeTransition(Duration.millis((double)100.0), (Node)this.getKeyBoard());
            this.animation.setOnFinished(e -> {
                if (this.animation.toValueProperty().get() == 0.0) {
                    this.hide();
                }
            });
        }
        this.animation.setFromValue(visible == Visibility.SHOW ? 0.0 : 1.0);
        this.animation.setToValue(visible == Visibility.SHOW ? 1.0 : 0.0);
        if (visible == Visibility.SHOW) {
            Window win = textNode != null && textNode.getScene() != null ? textNode.getScene().getWindow() : (this.owner != null ? this.owner.getWindow() : this.getOwnerWindow());
            if (this.isShowing() && this.getOwnerWindow() != win) {
                this.hide();
            }
            this.show(win);
        }
        this.animation.playFromStart();
    }

    public final double getOffset() {
        return this.offset == null ? this.offsetValue : this.offset.get();
    }

    public final void setOffset(double value) {
        if (this.offset == null) {
            this.offsetValue = value;
        } else {
            this.offset.set(value);
        }
    }

    public final DoubleProperty offsetProperty() {
        if (this.offset == null) {
            this.offset = new SimpleDoubleProperty((Object)this, "offset", this.offsetValue);
        }
        return this.offset;
    }

    public ChangeListener<? super Node> getFocusChangeListener() {
        return this.focusChangeListener;
    }

    public EventHandler<? super MouseEvent> getDoubleClickEventFilter() {
        return this.doubleClickEventFilter;
    }

    public static enum Visibility {
        SHOW,
        HIDE,
        POS;

    }
}

