/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.util.Builder;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyBoardBuilder;
import org.comtel2000.keyboard.control.KeyBoardPopup;
import org.comtel2000.keyboard.robot.IRobot;

public class KeyBoardPopupBuilder
implements Builder<KeyBoardPopup> {
    private final KeyBoardBuilder kb = KeyBoardBuilder.create();
    private double offset = -1.0;
    private EventHandler<? super Event> closeEventHandler;

    protected KeyBoardPopupBuilder() {
    }

    public static KeyBoardPopupBuilder create() {
        return new KeyBoardPopupBuilder();
    }

    public KeyBoardPopupBuilder layerPath(Path path) {
        this.kb.layerPath(path);
        return this;
    }

    public KeyBoardPopupBuilder initLocale(Locale locale) {
        this.kb.initLocale(locale);
        return this;
    }

    public KeyBoardPopupBuilder initScale(double scale) {
        this.kb.initScale(scale);
        return this;
    }

    public KeyBoardPopupBuilder addIRobot(IRobot robot) {
        this.kb.addIRobot(robot);
        return this;
    }

    public KeyBoardPopupBuilder layer(DefaultLayer l) {
        this.kb.layer(l);
        return this;
    }

    public KeyBoardPopupBuilder style(String css) {
        this.kb.style(css);
        return this;
    }

    public KeyBoardPopupBuilder offset(double offset) {
        this.offset = offset;
        return this;
    }

    public KeyBoardPopupBuilder onKeyboardCloseButton(EventHandler<? super Event> handler) {
        this.closeEventHandler = handler;
        return this;
    }

    public KeyBoardPopup build() {
        KeyBoardPopup popup = new KeyBoardPopup(this.kb.build());
        if (this.offset > -1.0) {
            popup.setOffset(this.offset);
        }
        popup.setOnKeyboardCloseButton((EventHandler<? super Event>)Objects.requireNonNullElseGet(this.closeEventHandler, () -> e -> popup.setVisible(KeyBoardPopup.Visibility.HIDE)));
        return popup;
    }
}

