/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.security.AccessController;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.comtel2000.keyboard.control.LongPressable;
import org.comtel2000.keyboard.event.KeyButtonEvent;

public abstract class KeyButton
extends Button
implements LongPressable {
    private static double KEY_LONG_PRESS_DELAY = 400.0;
    private static final double KEY_LONG_PRESS_DELAY_MIN = 100.0;
    private static final double KEY_LONG_PRESS_DELAY_MAX = 1000.0;
    Timeline buttonDelay;
    private String keyText;
    private boolean movable;
    private boolean sticky;
    private int keyCode;
    private ObjectProperty<EventHandler<? super KeyButtonEvent>> onLongPressed;
    private ObjectProperty<EventHandler<? super KeyButtonEvent>> onShortPressed;

    static {
        AccessController.doPrivileged(() -> {
            String s = System.getProperty("org.comtel2000.keyboard.longPressDelay");
            if (s != null) {
                Double delay = Double.valueOf(s);
                KEY_LONG_PRESS_DELAY = Math.min(Math.max(delay, 100.0), 1000.0);
            }
            return null;
        });
    }

    public KeyButton() {
        this(null, null, KEY_LONG_PRESS_DELAY);
    }

    public KeyButton(String label) {
        this(label, null, KEY_LONG_PRESS_DELAY);
    }

    public KeyButton(Node graphic) {
        this(null, graphic, KEY_LONG_PRESS_DELAY);
    }

    public KeyButton(String label, Node graphic) {
        this(label, graphic, KEY_LONG_PRESS_DELAY);
    }

    public KeyButton(String label, double delay) {
        this(label, null, delay);
    }

    public KeyButton(String label, Node graphic, double delay) {
        super(label, graphic);
        this.getStyleClass().add((Object)"key-button");
        this.initEventListener(delay > 0.0 ? delay : KEY_LONG_PRESS_DELAY);
    }

    protected abstract void initEventListener(double var1);

    void fireLongPressed() {
        this.fireEvent(new KeyButtonEvent(this, KeyButtonEvent.LONG_PRESSED));
    }

    void fireShortPressed() {
        this.fireEvent(new KeyButtonEvent(this, KeyButtonEvent.SHORT_PRESSED));
    }

    @Override
    public final EventHandler<? super KeyButtonEvent> getOnLongPressed() {
        return this.onLongPressed != null ? (EventHandler)this.onLongPressed.get() : null;
    }

    @Override
    public final void setOnLongPressed(EventHandler<? super KeyButtonEvent> h) {
        this.onLongPressedProperty().set(h);
    }

    @Override
    public final ObjectProperty<EventHandler<? super KeyButtonEvent>> onLongPressedProperty() {
        if (this.onLongPressed == null) {
            this.onLongPressed = new ObjectPropertyBase<EventHandler<? super KeyButtonEvent>>(){

                protected void invalidated() {
                    KeyButton.this.setEventHandler(KeyButtonEvent.LONG_PRESSED, (EventHandler)this.get());
                }

                public Object getBean() {
                    return KeyButton.this;
                }

                public String getName() {
                    return "onLongPressed";
                }
            };
        }
        return this.onLongPressed;
    }

    @Override
    public final EventHandler<? super KeyButtonEvent> getOnShortPressed() {
        return this.onShortPressed != null ? (EventHandler)this.onShortPressed.get() : null;
    }

    @Override
    public final void setOnShortPressed(EventHandler<? super KeyButtonEvent> h) {
        this.onShortPressedProperty().set(h);
    }

    @Override
    public final ObjectProperty<EventHandler<? super KeyButtonEvent>> onShortPressedProperty() {
        if (this.onShortPressed == null) {
            this.onShortPressed = new ObjectPropertyBase<EventHandler<? super KeyButtonEvent>>(){

                protected void invalidated() {
                    KeyButton.this.setEventHandler(KeyButtonEvent.SHORT_PRESSED, (EventHandler)this.get());
                }

                public Object getBean() {
                    return KeyButton.this;
                }

                public String getName() {
                    return "onShortPressed";
                }
            };
        }
        return this.onShortPressed;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }

    public String getKeyText() {
        return this.keyText;
    }

    public void setKeyText(String keyText) {
        this.keyText = keyText;
    }

    public void addExtKeyCode(int keyCode, String label) {
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }
}

