/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyButton;
import org.comtel2000.keyboard.control.KeyboardType;
import org.comtel2000.keyboard.control.MultiKeyButton;
import org.comtel2000.keyboard.control.RepeatableKeyButton;
import org.comtel2000.keyboard.control.ShortPressKeyButton;
import org.comtel2000.keyboard.control.StandardKeyCode;
import org.comtel2000.keyboard.event.KeyButtonEvent;
import org.comtel2000.keyboard.robot.FXRobotHandler;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.keyboard.xml.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyboardPane
extends Region
implements StandardKeyCode,
EventHandler<KeyButtonEvent> {
    private static final Logger logger = LoggerFactory.getLogger(KeyboardPane.class);
    private static final String DEFAULT_CSS = "/css/KeyboardButtonStyle.css";
    private final EnumMap<KeyboardType, Region> typeRegionMap = new EnumMap(KeyboardType.class);
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private final List<IRobot> robots = new ArrayList<IRobot>();
    private final Map<URL, Region> layoutCache = new HashMap<URL, Region>();
    private final Map<Locale, String> availableLocales = new LinkedHashMap<Locale, String>();
    private String _keyBoardStyle;
    private StringProperty keyBoardStyle;
    private boolean _cacheLayout = true;
    private BooleanProperty cacheLayout;
    private boolean _symbol;
    private BooleanProperty symbol;
    private boolean _shift;
    private BooleanProperty shift;
    private boolean _control;
    private BooleanProperty control;
    private boolean _spaceKeyMove = true;
    private BooleanProperty spaceKeyMove;
    private boolean _capsLock = true;
    private BooleanProperty capsLock;
    private double _scaleOffset = 0.2;
    private DoubleProperty scaleOffset;
    private double _scale = 1.0;
    private DoubleProperty scale;
    private double _minScale = 0.7;
    private DoubleProperty minScale;
    private double _maxScale = 5.0;
    private DoubleProperty maxScale;
    private DefaultLayer _layer = DefaultLayer.DEFAULT;
    private ObjectProperty<DefaultLayer> layer;
    private Path _layerPath;
    private ObjectProperty<Path> layerPath;
    private Locale _locale = Locale.getDefault();
    private ObjectProperty<Locale> locale;
    private Locale _activeLocale;
    private ObjectProperty<Locale> activeLocale;
    private KeyboardType _activeType;
    private ObjectProperty<KeyboardType> activeType;
    private EventHandler<? super Event> closeEventHandler;
    private double mousePressedX;
    private double mousePressedY;
    private EventHandler<MouseEvent> movedHandler;
    private EventHandler<MouseEvent> draggedHandler;

    static {
        $SWITCH_TABLE$org$comtel2000$keyboard$control$KeyboardType = KeyboardPane.$SWITCH_TABLE$org$comtel2000$keyboard$control$KeyboardType();
    }

    public KeyboardPane() {
        this.getStyleClass().add((Object)"key-background");
        this.setFocusTraversable(false);
    }

    public String getUserAgentStylesheet() {
        return this.getKeyBoardStyle();
    }

    public void load() throws Exception {
        if (this.robots.isEmpty()) {
            logger.debug("load default fx robot handler");
            this.robots.add(new FXRobotHandler());
        }
        this.getStylesheets().add((Object)this.getKeyBoardStyle());
        this.setLayoutLocale(this.getLocale());
        this.setKeyboardType(KeyboardType.TEXT);
        if (this.getScale() != 1.0) {
            this.setScaleX(this.getScale());
            this.setScaleY(this.getScale());
        }
        this.setOnZoom(e -> {
            double s = this.getScale() * e.getTotalZoomFactor();
            if (s >= this.getMinScale() && s <= this.getMaxScale()) {
                this.setScale(s);
                e.consume();
            }
        });
        this.setOnScroll(e -> {
            double s = this.getScale() + (e.getDeltaY() > 0.0 ? this.getScaleOffset() : -this.getScaleOffset());
            if (s >= this.getMinScale() && s <= this.getMaxScale()) {
                this.setScale(s);
                e.consume();
            }
        });
    }

    private void setKeyboardType(boolean ctrl, boolean shift, boolean symbol) {
        if (ctrl) {
            this.setKeyboardType(KeyboardType.CTRL);
            return;
        }
        if (symbol) {
            this.setKeyboardType(shift ? KeyboardType.SYMBOL_SHIFT : KeyboardType.SYMBOL);
            return;
        }
        this.setKeyboardType(shift ? KeyboardType.TEXT_SHIFT : KeyboardType.TEXT);
    }

    public void resetLocale() {
        this.switchLocale(this.getLocale());
    }

    public void switchLocale(Locale local) {
        try {
            if (local.equals(this.getActiveLocale())) {
                return;
            }
            this.setLayoutLocale(local);
            this.setActiveType(null);
            this.setKeyboardType(KeyboardType.TEXT);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void switchLayer(DefaultLayer layer) {
        if (layer.equals((Object)this.getLayer())) {
            logger.warn("layer already selected");
            return;
        }
        try {
            this.setLayerPath(null);
            this.setLayer(layer);
            this.availableLocales.clear();
            this.setActiveLocale(null);
            this.setLayoutLocale(this.getLocale());
            this.setActiveType(null);
            this.setKeyboardType(KeyboardType.TEXT);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setLayoutLocale(Locale local) throws Exception {
        logger.debug("try to set keyboard local: {}->{}", (Object)this.getActiveLocale(), (Object)local);
        Map<Locale, String> localeMap = this.getAvailableLocales();
        if (localeMap.containsKey(local)) {
            if (local.equals(this.getActiveLocale())) {
                logger.debug("locale already active: {}", (Object)local);
                return;
            }
            this.setActiveLocale(local);
        } else if (localeMap.containsKey(Locale.forLanguageTag(local.getLanguage()))) {
            if (Locale.forLanguageTag(local.getLanguage()).equals(this.getActiveLocale())) {
                logger.debug("locale language already active: {}", (Object)local);
                return;
            }
            this.setActiveLocale(Locale.forLanguageTag(local.getLanguage()));
        } else {
            if (Locale.ENGLISH.equals(this.getActiveLocale())) {
                logger.debug("locale language already active: {}", (Object)local);
                return;
            }
            this.setActiveLocale(Locale.ENGLISH);
        }
        logger.debug("use keyboard local: {}", (Object)this.getActiveLocale());
        String root = localeMap.get(this.getActiveLocale());
        this.addTypeRegion(KeyboardType.TEXT, root, "kb-layout.xml");
        this.addTypeRegion(KeyboardType.TEXT_SHIFT, root, "kb-layout-shift.xml");
        this.addTypeRegion(KeyboardType.SYMBOL, root, "kb-layout-sym.xml");
        this.addTypeRegion(KeyboardType.SYMBOL_SHIFT, root, "kb-layout-sym-shift.xml");
        this.addTypeRegion(KeyboardType.CTRL, root, "kb-layout-ctrl.xml");
        this.addTypeRegion(KeyboardType.NUMERIC, root, "kb-layout-numeric.xml");
        this.addTypeRegion(KeyboardType.EMAIL, root, "kb-layout-email.xml");
        this.addTypeRegion(KeyboardType.URL, root, "kb-layout-url.xml");
    }

    private void addTypeRegion(KeyboardType type, String root, String file) throws Exception {
        URL url = KeyboardPane.class.getResource(String.valueOf(root) + "/" + file);
        if (url == null && Files.exists(Paths.get(root, file), new LinkOption[0])) {
            url = Paths.get(root, file).toUri().toURL();
        }
        if (url != null) {
            logger.debug("add layout: {}", (Object)url);
            this.typeRegionMap.put(type, this.getKeyboardPane(url));
            return;
        }
        String defaultRoot = this.getAvailableLocales().get(Locale.ENGLISH);
        if (defaultRoot == null) {
            logger.error("layout: {} / {} not found - no default available", (Object)root, (Object)file);
            return;
        }
        url = KeyboardPane.class.getResource(String.valueOf(defaultRoot) + "/" + file);
        if (url != null) {
            logger.debug("add default layout: {}", (Object)url);
            this.typeRegionMap.put(type, this.getKeyboardPane(url));
            return;
        }
        if (Files.exists(Paths.get(defaultRoot, file), new LinkOption[0])) {
            url = Paths.get(defaultRoot, file).toUri().toURL();
            logger.debug("add default layout: {}", (Object)url);
            this.typeRegionMap.put(type, this.getKeyboardPane(url));
        }
    }

    private Map<Locale, String> getAvailableLocales() {
        Object layer;
        if (!this.availableLocales.isEmpty()) {
            return this.availableLocales;
        }
        if (this.getLayerPath() == null) {
            layer = this.getLayer().toString().toLowerCase(Locale.ENGLISH);
            URL url = Objects.requireNonNull(KeyboardPane.class.getResource("/xml/" + (String)layer));
            logger.debug("use embedded layer path: {}", (Object)url);
            if (url.toExternalForm().contains("!")) {
                this.availableLocales.put(Locale.ENGLISH, "/xml/" + (String)layer);
                this.readJarLocales(url);
                return this.availableLocales;
            }
            try {
                this.setLayerPath(Paths.get(url.toURI()));
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.availableLocales.put(Locale.ENGLISH, this.getLayerPath().toString());
        try {
            layer = null;
            Object var2_4 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getLayerPath());){
                for (Path p : stream) {
                    if (!Files.isDirectory(p, new LinkOption[0])) continue;
                    Locale locale = new Locale(p.getFileName().toString());
                    this.availableLocales.put(locale, p.toString());
                }
            }
            catch (Throwable throwable) {
                if (layer == null) {
                    layer = throwable;
                } else if (layer != throwable) {
                    ((Throwable)layer).addSuppressed(throwable);
                }
                throw layer;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.debug("locales: {}", this.availableLocales.keySet());
        return this.availableLocales;
    }

    private void readJarLocales(URL url) {
        String[] array = url.toExternalForm().split("!");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), Collections.emptyMap());){
                Path path = fs.getPath(array[1], new String[0]);
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                    for (Path p : stream) {
                        if (!Files.isDirectory(p, new LinkOption[0])) continue;
                        String lang = p.getFileName().toString().replace("/", "");
                        this.availableLocales.put(new Locale(lang), String.valueOf(array[1]) + "/" + lang);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setKeyboardType(String type) {
        try {
            this.setKeyboardType(type == null || type.isEmpty() ? KeyboardType.TEXT : KeyboardType.valueOf(type.toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception e) {
            logger.error("unknown type: {}", (Object)type);
            this.setKeyboardType(KeyboardType.TEXT);
        }
    }

    public void setKeyboardType(KeyboardType type) {
        Region pane;
        logger.debug("try to set type: {}->{}", (Object)this.getActiveType(), (Object)type);
        if (type.equals((Object)this.getActiveType())) {
            return;
        }
        this.setActiveType(type);
        switch (type) {
            case NUMERIC: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.getOrDefault((Object)type, this.typeRegionMap.get((Object)KeyboardType.SYMBOL));
                break;
            }
            case EMAIL: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case URL: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case SYMBOL: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(true);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case SYMBOL_SHIFT: {
                this.setControl(false);
                this.setShift(true);
                this.setSymbol(true);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case CTRL: {
                this.setControl(true);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case TEXT_SHIFT: {
                this.setControl(false);
                this.setShift(true);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            default: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
            }
        }
        if (pane == null) {
            pane = this.typeRegionMap.get((Object)KeyboardType.TEXT);
        }
        if (pane != null) {
            this.getChildren().setAll((Object[])new Node[]{pane});
        }
    }

    private Region getKeyboardPane(URL layout) {
        if (this.isCacheLayout()) {
            return this.layoutCache.computeIfAbsent(layout, this::createKeyboardPane);
        }
        return this.createKeyboardPane(layout);
    }

    private Region createKeyboardPane(URL layout) {
        GridPane rowPane;
        block35: {
            rowPane = new GridPane();
            rowPane.setAlignment(Pos.CENTER);
            rowPane.getStyleClass().add((Object)"key-background-row");
            double keyWidth = 10.0;
            double keyHeight = 35.0;
            double horizontalGap = 5.0;
            double verticalGap = 5.0;
            int colIndex = -1;
            int rowIndex = -1;
            double rowWidth = 0.0;
            double minRowWidth = -1.0;
            double maxRowWidth = -1.0;
            GridPane colPane = null;
            XMLStreamReader reader = null;
            try {
                try {
                    reader = this.factory.createXMLStreamReader(layout.openStream());
                    block22: while (reader.hasNext()) {
                        reader.next();
                        switch (reader.getEventType()) {
                            case 1: {
                                switch (reader.getLocalName()) {
                                    case "Keyboard": {
                                        verticalGap = XmlHelper.readDoubleAttribute(reader, "verticalGap", verticalGap);
                                        rowPane.setVgap(verticalGap);
                                        horizontalGap = XmlHelper.readDoubleAttribute(reader, "horizontalGap", horizontalGap);
                                        keyWidth = XmlHelper.readDoubleAttribute(reader, "keyWidth", keyWidth);
                                        keyHeight = XmlHelper.readDoubleAttribute(reader, "keyHeight", keyHeight);
                                        break;
                                    }
                                    case "Row": {
                                        ++rowIndex;
                                        colIndex = -1;
                                        rowWidth = 0.0;
                                        colPane = new GridPane();
                                        colPane.setHgap(horizontalGap);
                                        colPane.getStyleClass().add((Object)"key-background-column");
                                        rowPane.add((Node)colPane, 0, rowIndex);
                                        RowConstraints rc = new RowConstraints();
                                        rc.setPrefHeight(keyHeight);
                                        colPane.getRowConstraints().add((Object)rc);
                                        XmlHelper.readAttribute(reader, "rowEdgeFlags").ifPresent(flag -> rc.setValignment(VPos.valueOf((String)flag.toUpperCase())));
                                        break;
                                    }
                                    case "Key": {
                                        ++colIndex;
                                        ColumnConstraints cc = new ColumnConstraints();
                                        cc.setHgrow(Priority.SOMETIMES);
                                        cc.setFillWidth(true);
                                        cc.setPrefWidth(XmlHelper.readDoubleAttribute(reader, "keyWidth", keyWidth));
                                        String code = reader.getAttributeValue(null, "codes");
                                        if (code == null || code.isEmpty()) {
                                            Pane placeholder = new Pane();
                                            colPane.add((Node)placeholder, colIndex, 0);
                                            colPane.getColumnConstraints().add((Object)cc);
                                            rowWidth += cc.getPrefWidth();
                                            break;
                                        }
                                        String[] codes = code.split(",");
                                        KeyButton button = codes.length > 1 || code.equals(Integer.toString(-7)) ? new MultiKeyButton((Parent)this, (Collection<String>)this.getStylesheets()) : (XmlHelper.readBooleanAttribute(reader, "repeatable", false) ? new RepeatableKeyButton() : new ShortPressKeyButton());
                                        button.setFocusTraversable(false);
                                        button.setOnShortPressed(this);
                                        button.setMinHeight(1.0);
                                        button.setPrefHeight(keyHeight);
                                        button.setPrefWidth(keyWidth);
                                        button.setMaxWidth(Double.MAX_VALUE);
                                        button.setMovable(XmlHelper.readBooleanAttribute(reader, "movable", false));
                                        if (button.isMovable()) {
                                            this.installMoveHandler((Node)button);
                                            button.getStyleClass().add((Object)"movable-style");
                                        }
                                        button.setSticky(XmlHelper.readBooleanAttribute(reader, "sticky", false));
                                        if (button.isSticky()) {
                                            button.getStyleClass().add((Object)"sticky-style");
                                        }
                                        XmlHelper.readAttribute(reader, "keyLabelStyle").ifPresent(s -> {
                                            if (s.charAt(0) == '.') {
                                                String[] stringArray = s.split(";");
                                                int n = stringArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    String style = stringArray[n2];
                                                    button.getStyleClass().add((Object)style.substring(1));
                                                    ++n2;
                                                }
                                            }
                                        });
                                        if (codes.length > 0 && !codes[0].isEmpty()) {
                                            button.setKeyCode(XmlHelper.parseInt(codes[0]));
                                        }
                                        if (codes.length > 1) {
                                            int i = 1;
                                            while (i < codes.length) {
                                                int keyCode = XmlHelper.parseInt(codes[i]);
                                                button.addExtKeyCode(keyCode, Character.toString((char)keyCode));
                                                ++i;
                                            }
                                        }
                                        if (button.getKeyCode() == -7) {
                                            for (Locale l : this.getAvailableLocales().keySet()) {
                                                button.addExtKeyCode(-7, l.getLanguage().toUpperCase(Locale.ENGLISH));
                                            }
                                        }
                                        XmlHelper.readAttribute(reader, "keyIconStyle").ifPresent(s -> {
                                            if (s.charAt(0) == '.') {
                                                logger.trace("Load css style: {}", s);
                                                Label icon = new Label();
                                                String[] stringArray = s.split(";");
                                                int n = stringArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    String style = stringArray[n2];
                                                    icon.getStyleClass().add((Object)style.substring(1));
                                                    ++n2;
                                                }
                                                icon.setMaxSize(40.0, 40.0);
                                                button.setContentDisplay(ContentDisplay.CENTER);
                                                button.setGraphic((Node)icon);
                                            } else if (s.charAt(0) == '@') {
                                                try {
                                                    Throwable icon = null;
                                                    Object var3_12 = null;
                                                    try (InputStream is = KeyboardPane.class.getResourceAsStream(String.valueOf(s.replace('@', '/')) + ".png");){
                                                        Image image = new Image(is);
                                                        if (!image.isError()) {
                                                            button.setGraphic((Node)new ImageView(image));
                                                        } else {
                                                            logger.error("Image: {} not found", s);
                                                        }
                                                    }
                                                    catch (Throwable throwable) {
                                                        if (icon == null) {
                                                            icon = throwable;
                                                        } else if (icon != throwable) {
                                                            icon.addSuppressed(throwable);
                                                        }
                                                        throw icon;
                                                    }
                                                }
                                                catch (Exception e) {
                                                    logger.error(e.getMessage(), (Throwable)e);
                                                }
                                            }
                                        });
                                        String label = reader.getAttributeValue(null, "keyLabel");
                                        button.setText(label != null ? label : Character.toString((char)button.getKeyCode()));
                                        XmlHelper.readAttribute(reader, "keyOutputText").ifPresent(button::setKeyText);
                                        cc.setHalignment(HPos.CENTER);
                                        button.setAlignment(Pos.BASELINE_CENTER);
                                        XmlHelper.readAttribute(reader, "keyEdgeFlags").ifPresent(flag -> {
                                            switch (flag) {
                                                case "right": {
                                                    cc.setHalignment(HPos.RIGHT);
                                                    button.setAlignment(Pos.BASELINE_RIGHT);
                                                    break;
                                                }
                                                case "left": {
                                                    cc.setHalignment(HPos.LEFT);
                                                    button.setAlignment(Pos.BASELINE_LEFT);
                                                    break;
                                                }
                                                default: {
                                                    cc.setHalignment(HPos.CENTER);
                                                }
                                            }
                                        });
                                        switch (button.getKeyCode()) {
                                            case 32: {
                                                this.installMoveHandler((Node)button);
                                                break;
                                            }
                                            case -8: 
                                            case -5: {
                                                if (button.isRepeatable()) break;
                                                button.setOnLongPressed((EventHandler<? super KeyButtonEvent>)((EventHandler)e -> {
                                                    this.sendToComponent('a', true);
                                                    this.sendToComponent('\u007f', this.isControl());
                                                }));
                                                break;
                                            }
                                        }
                                        colPane.add((Node)button, colIndex, 0);
                                        colPane.getColumnConstraints().add((Object)cc);
                                        rowWidth += colPane.getHgap() + cc.getPrefWidth();
                                    }
                                }
                                continue block22;
                            }
                            case 2: {
                                if (!reader.getLocalName().equals("Row")) break;
                                maxRowWidth = Math.max(maxRowWidth, rowWidth);
                                minRowWidth = minRowWidth == -1.0 ? rowWidth : Math.min(minRowWidth, rowWidth);
                                logger.trace("{} - [{}/{}] url: {}", new Object[]{rowWidth, rowIndex, colIndex, layout.getPath()});
                                break;
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                    XmlHelper.close(reader);
                    break block35;
                }
            }
            catch (Throwable throwable) {
                XmlHelper.close(reader);
                throw throwable;
            }
            XmlHelper.close(reader);
        }
        return rowPane;
    }

    public void handle(KeyButtonEvent event) {
        if (!event.getEventType().equals(KeyButtonEvent.SHORT_PRESSED)) {
            logger.warn("ignore non short pressed events");
            return;
        }
        event.consume();
        KeyButton kb = (KeyButton)event.getSource();
        switch (kb.getKeyCode()) {
            case -1: {
                this.setKeyboardType(this.isControl(), !this.isShift(), this.isSymbol());
                break;
            }
            case -2: {
                this.setKeyboardType(this.isControl(), this.isShift(), !this.isSymbol());
                break;
            }
            case -3: {
                if (this.closeEventHandler == null) {
                    new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)50.0), ev -> this.fireEvent((Event)new WindowEvent(this.getScene().getWindow(), WindowEvent.WINDOW_CLOSE_REQUEST)), new KeyValue[0])}).playFromStart();
                    break;
                }
                new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)50.0), ev -> this.closeEventHandler.handle((Event)event), new KeyValue[0])}).playFromStart();
                break;
            }
            case -4: {
                this.sendToComponent('\t', true);
                break;
            }
            case -5: {
                this.sendToComponent('\b', true);
                break;
            }
            case -8: {
                this.sendToComponent('\u007f', true);
                break;
            }
            case -6: {
                this.setControl(!this.isControl());
                this.setKeyboardType(this.isControl(), this.isShift(), this.isSymbol());
                break;
            }
            case -7: {
                this.switchLocale(Locale.forLanguageTag(kb.getText()));
                break;
            }
            case -9: {
                this.sendToComponent('\n', true);
                break;
            }
            case -10: {
                this.sendToComponent('&', true);
                break;
            }
            case -11: {
                this.sendToComponent('(', true);
                break;
            }
            case -12: {
                this.sendToComponent('%', true);
                break;
            }
            case -13: {
                this.sendToComponent('\'', true);
                break;
            }
            case -14: {
                this.sendToComponent('Z', true);
                break;
            }
            case -15: {
                this.sendToComponent('Y', true);
                break;
            }
            case -20: {
                this.sendToComponent('$', true);
                break;
            }
            case -21: {
                this.sendToComponent('#', true);
                break;
            }
            case -22: {
                this.sendToComponent('!', true);
                break;
            }
            case -23: {
                this.sendToComponent('\"', true);
                break;
            }
            case -24: {
                this.sendToComponent('\u009c', true);
                break;
            }
            case -16: {
                this.setKeyboardType(KeyboardType.NUMERIC);
                break;
            }
            case -17: {
                this.setKeyboardType(KeyboardType.EMAIL);
                break;
            }
            case -18: {
                this.setKeyboardType(KeyboardType.URL);
                break;
            }
            case -19: {
                this.setCapsLock(!this.isCapsLock());
                break;
            }
            case -25: {
                double opacity = this.getScene().getWindow().getOpacity();
                this.getScene().getWindow().setOpacity(0.0);
                this.sendToComponent('\u009a', true);
                Timeline timeline = new Timeline();
                timeline.setDelay(Duration.millis((double)1000.0));
                timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.getScene().getWindow().opacityProperty(), (Object)opacity)}));
                timeline.play();
                break;
            }
            case -123: 
            case -122: 
            case -121: 
            case -120: 
            case -119: 
            case -118: 
            case -117: 
            case -116: 
            case -115: 
            case -114: 
            case -113: 
            case -112: {
                this.sendToComponent((char)Math.abs(kb.getKeyCode()), true);
                break;
            }
            default: {
                if (kb.getKeyText() != null) {
                    int i = 0;
                    while (i < kb.getKeyText().length()) {
                        this.sendToComponent(kb.getKeyText().charAt(i), this.isControl());
                        ++i;
                    }
                } else if (kb.getKeyCode() > -1) {
                    this.sendToComponent((char)kb.getKeyCode(), this.isControl());
                } else {
                    logger.debug("unknown key code: {}", (Object)kb.getKeyCode());
                    this.sendToComponent((char)kb.getKeyCode(), true);
                }
                if (this.isCapsLock() || !this.isShift()) break;
                this.setKeyboardType(this.isControl(), !this.isShift(), this.isSymbol());
            }
        }
    }

    private void sendToComponent(char ch, boolean ctrl) {
        logger.trace("send ({}) ctrl={}", (Object)Character.valueOf(ch), (Object)ctrl);
        if (ctrl) {
            switch (Character.toUpperCase(ch)) {
                case '-': {
                    if (this.getScale() - this.getScaleOffset() >= this.getMinScale()) {
                        this.setScale(this.getScale() - this.getScaleOffset());
                    }
                    return;
                }
                case '+': {
                    if (this.getScale() + this.getScaleOffset() <= this.getMaxScale()) {
                        this.setScale(this.getScale() + this.getScaleOffset());
                    }
                    return;
                }
            }
        }
        if (this.robots.isEmpty()) {
            logger.error("no robot handler available");
            return;
        }
        for (IRobot robot : this.robots) {
            robot.sendToComponent(this, ch, ctrl);
        }
    }

    public void addRobotHandler(IRobot robot) {
        this.robots.add(robot);
    }

    public List<IRobot> getRobotHandler() {
        return Collections.unmodifiableList(this.robots);
    }

    public void removeRobotHandler(IRobot robot) {
        this.robots.remove(robot);
    }

    public void setOnKeyboardCloseButton(EventHandler<? super Event> value) {
        this.closeEventHandler = value;
    }

    public final String getKeyBoardStyle() {
        if (this.keyBoardStyle != null) {
            return (String)this.keyBoardStyle.get();
        }
        if (this._keyBoardStyle == null) {
            URL stylesheet = KeyboardPane.class.getResource(DEFAULT_CSS);
            this._keyBoardStyle = stylesheet.toString();
        }
        return this._keyBoardStyle;
    }

    public final void setKeyBoardStyle(String style) {
        if (this.keyBoardStyle == null) {
            this._keyBoardStyle = style;
        } else {
            this.keyBoardStyle.set((Object)style);
        }
    }

    public final StringProperty keyBoardStyleProperty() {
        if (this.keyBoardStyle == null) {
            this.keyBoardStyle = new SimpleStringProperty((Object)this, "keyBoardStyle", this._keyBoardStyle);
        }
        return this.keyBoardStyle;
    }

    public final boolean isCacheLayout() {
        return this.cacheLayout == null ? this._cacheLayout : this.cacheLayout.get();
    }

    public final void setCacheLayout(boolean s) {
        if (this.cacheLayout == null) {
            this._cacheLayout = s;
        } else {
            this.cacheLayout.set(s);
        }
    }

    public final BooleanProperty cacheLayoutProperty() {
        if (this.cacheLayout == null) {
            this.cacheLayout = new SimpleBooleanProperty((Object)this, "cacheLayout", this._cacheLayout);
        }
        return this.cacheLayout;
    }

    public final boolean isSymbol() {
        return this.symbol == null ? this._symbol : this.symbol.get();
    }

    public final void setSymbol(boolean s) {
        if (this.symbol == null) {
            this._symbol = s;
        } else {
            this.symbol.set(s);
        }
    }

    public final BooleanProperty symbolProperty() {
        if (this.symbol == null) {
            this.symbol = new SimpleBooleanProperty((Object)this, "symbol", this._symbol);
        }
        return this.symbol;
    }

    public final boolean isShift() {
        return this.shift == null ? this._shift : this.shift.get();
    }

    public final void setShift(boolean s) {
        if (this.shift == null) {
            this._shift = s;
        } else {
            this.shift.set(s);
        }
    }

    public final BooleanProperty shiftProperty() {
        if (this.shift == null) {
            this.shift = new SimpleBooleanProperty((Object)this, "shift", this._shift);
        }
        return this.shift;
    }

    public final boolean isControl() {
        return this.control == null ? this._control : this.control.get();
    }

    public final void setControl(boolean s) {
        if (this.control == null) {
            this._control = s;
        } else {
            this.control.set(s);
        }
    }

    public final BooleanProperty controlProperty() {
        if (this.control == null) {
            this.control = new SimpleBooleanProperty((Object)this, "control", this._control);
        }
        return this.control;
    }

    public final boolean isSpaceKeyMove() {
        return this.spaceKeyMove == null ? this._spaceKeyMove : this.spaceKeyMove.get();
    }

    public final void setSpaceKeyMove(boolean s) {
        if (this.spaceKeyMove == null) {
            this._spaceKeyMove = s;
        } else {
            this.spaceKeyMove.set(s);
        }
    }

    public final BooleanProperty spaceKeyMoveProperty() {
        if (this.spaceKeyMove == null) {
            this.spaceKeyMove = new SimpleBooleanProperty((Object)this, "spaceKeyMove", this._spaceKeyMove);
        }
        return this.spaceKeyMove;
    }

    public final boolean isCapsLock() {
        return this.capsLock == null ? this._capsLock : this.capsLock.get();
    }

    public final void setCapsLock(boolean s) {
        if (this.capsLock == null) {
            this._capsLock = s;
        } else {
            this.capsLock.set(s);
        }
    }

    public final BooleanProperty capsLockProperty() {
        if (this.capsLock == null) {
            this.capsLock = new SimpleBooleanProperty((Object)this, "capsLock", this._capsLock);
        }
        return this.capsLock;
    }

    public final double getScaleOffset() {
        return this.scaleOffset == null ? this._scaleOffset : this.scaleOffset.get();
    }

    public final void setScaleOffset(double s) {
        if (this.scaleOffset == null) {
            this._scaleOffset = s;
        } else {
            this.scaleOffset.set(s);
        }
    }

    public final DoubleProperty scaleOffsetProperty() {
        if (this.scaleOffset == null) {
            this.scaleOffset = new SimpleDoubleProperty((Object)this, "scaleOffset", this._scaleOffset);
        }
        return this.scaleOffset;
    }

    public final double getScale() {
        return this.scale == null ? this._scale : this.scale.get();
    }

    public final void setScale(double s) {
        if (this.scale == null) {
            this._scale = s;
            this.setScaleX(this._scale);
            this.setScaleY(this._scale);
        } else {
            this.scale.set(s);
        }
    }

    public final DoubleProperty scaleProperty() {
        if (this.scale == null) {
            this.scale = new SimpleDoubleProperty((Object)this, "scale", this._scale);
            this.scale.addListener((l, o, s) -> {
                if (!Objects.equals(o, s)) {
                    this.setScaleX(s.doubleValue());
                    this.setScaleY(s.doubleValue());
                }
            });
        }
        return this.scale;
    }

    public final double getMinScale() {
        return this.minScale == null ? this._minScale : this.minScale.get();
    }

    public final void setMinScale(double s) {
        if (this.minScale == null) {
            this._minScale = s;
        } else {
            this.minScale.set(s);
        }
    }

    public final DoubleProperty minScaleProperty() {
        if (this.minScale == null) {
            this.minScale = new SimpleDoubleProperty((Object)this, "minScale", this._minScale);
        }
        return this.minScale;
    }

    public final double getMaxScale() {
        return this.maxScale == null ? this._maxScale : this.maxScale.get();
    }

    public final void setMaxScale(double s) {
        if (this.maxScale == null) {
            this._maxScale = s;
        } else {
            this.maxScale.set(s);
        }
    }

    public final DoubleProperty maxScaleProperty() {
        if (this.maxScale == null) {
            this.maxScale = new SimpleDoubleProperty((Object)this, "maxScale", this._maxScale);
        }
        return this.maxScale;
    }

    public final DefaultLayer getLayer() {
        return this.layer == null ? this._layer : (DefaultLayer)((Object)this.layer.get());
    }

    public final void setLayer(DefaultLayer l) {
        if (this.layer == null) {
            this._layer = l;
        } else {
            this.layer.set((Object)l);
        }
    }

    public final ObjectProperty<DefaultLayer> layerProperty() {
        if (this.layer == null) {
            this.layer = new SimpleObjectProperty((Object)this, "layer", (Object)this._layer);
        }
        return this.layer;
    }

    public final Path getLayerPath() {
        return this.layerPath == null ? this._layerPath : (Path)this.layerPath.get();
    }

    public final void setLayerPath(Path l) {
        if (this.layerPath == null) {
            this._layerPath = l;
        } else {
            this.layerPath.set((Object)l);
        }
    }

    public final ObjectProperty<Path> layerPathProperty() {
        if (this.layerPath == null) {
            this.layerPath = new SimpleObjectProperty((Object)this, "layerPath", (Object)this._layerPath);
        }
        return this.layerPath;
    }

    public final Locale getLocale() {
        return this.locale == null ? this._locale : (Locale)this.locale.get();
    }

    public final void setLocale(Locale l) {
        if (this.locale == null) {
            this._locale = l;
        } else {
            this.locale.set((Object)l);
        }
    }

    public final ObjectProperty<Locale> localeProperty() {
        if (this.locale == null) {
            this.locale = new SimpleObjectProperty((Object)this, "locale", (Object)this._locale);
        }
        return this.locale;
    }

    public final Locale getActiveLocale() {
        return this.activeLocale == null ? this._activeLocale : (Locale)this.activeLocale.get();
    }

    public final void setActiveLocale(Locale l) {
        if (this.activeLocale == null) {
            this._activeLocale = l;
        } else {
            this.activeLocale.set((Object)l);
        }
    }

    public final ObjectProperty<Locale> activeLocaleProperty() {
        if (this.activeLocale == null) {
            this.activeLocale = new SimpleObjectProperty((Object)this, "activeLocale", (Object)this._activeLocale);
        }
        return this.activeLocale;
    }

    public final KeyboardType getActiveType() {
        return this.activeType == null ? this._activeType : (KeyboardType)((Object)this.activeType.get());
    }

    public final void setActiveType(KeyboardType l) {
        if (this.activeType == null) {
            this._activeType = l;
        } else {
            this.activeType.set((Object)l);
        }
    }

    public final ObjectProperty<KeyboardType> activeTypeProperty() {
        if (this.activeType == null) {
            this.activeType = new SimpleObjectProperty((Object)this, "activeType", (Object)this._activeType);
        }
        return this.activeType;
    }

    private void installMoveHandler(Node node) {
        if (this.movedHandler == null) {
            this.movedHandler = e -> {
                if (this.isSpaceKeyMove()) {
                    this.mousePressedX = this.getScene().getWindow().getX() - e.getScreenX();
                    this.mousePressedY = this.getScene().getWindow().getY() - e.getScreenY();
                }
            };
        }
        if (this.draggedHandler == null) {
            this.draggedHandler = e -> {
                if (this.isSpaceKeyMove()) {
                    this.getScene().getWindow().setX(e.getScreenX() + this.mousePressedX);
                    this.getScene().getWindow().setY(e.getScreenY() + this.mousePressedY);
                }
            };
        }
        node.setOnMouseMoved(this.movedHandler);
        node.setOnMouseDragged(this.draggedHandler);
    }
}

