/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.util.Collection;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseButton;
import javafx.util.Duration;
import org.comtel2000.keyboard.control.KeyButton;
import org.comtel2000.keyboard.control.MultiKeyPopup;
import org.comtel2000.keyboard.control.ShortPressKeyButton;
import org.comtel2000.keyboard.event.KeyButtonEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiKeyButton
extends KeyButton {
    private static final Logger logger = LoggerFactory.getLogger(MultiKeyButton.class);
    private final Collection<String> styles;
    private final Parent parent;
    private MultiKeyPopup context;

    MultiKeyButton(Parent parent, Collection<String> styles) {
        this.getStyleClass().add((Object)"multi-button");
        this.styles = styles;
        this.parent = parent;
    }

    @Override
    protected void initEventListener(double delay) {
        this.buttonDelay = new Timeline(new KeyFrame[]{new KeyFrame(new Duration(delay), event -> this.fireLongPressed(), new KeyValue[0])});
        this.setOnDragDetected(e -> {
            logger.trace("{} drag detected", (Object)this.getKeyCode());
            if (this.buttonDelay.getStatus().equals((Object)Animation.Status.RUNNING) && this.buttonDelay.getCurrentRate() > 0.0) {
                this.buttonDelay.stop();
                this.fireLongPressed();
            }
            e.consume();
        });
        this.setOnMouseClicked(event -> {
            logger.trace("{} clicked: {}", (Object)this.getKeyCode(), (Object)this.buttonDelay.getCurrentRate());
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && this.buttonDelay.getStatus().equals((Object)Animation.Status.RUNNING)) {
                this.buttonDelay.stop();
                this.fireShortPressed();
            }
            this.setFocused(false);
            event.consume();
        });
        this.setOnMousePressed(event -> {
            logger.trace("{} pressed: {}", (Object)this.getKeyCode(), (Object)this.buttonDelay.getCurrentRate());
            if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
                this.buttonDelay.playFromStart();
            }
            event.consume();
        });
    }

    private MultiKeyPopup getContext() {
        if (this.context == null) {
            this.context = new MultiKeyPopup();
            this.context.getStylesheets().setAll(this.styles);
            this.context.setOnHidden(event -> {
                this.parent.setEffect(null);
                this.parent.setDisable(false);
            });
            this.setOnLongPressed((EventHandler<? super KeyButtonEvent>)((EventHandler)event -> {
                Node node = (Node)event.getSource();
                this.parent.setDisable(true);
                this.setFocused(false);
                this.context.show(node, this.parent.getScaleX());
            }));
        }
        return this.context;
    }

    @Override
    public void addExtKeyCode(int extKeyCode, String label) {
        ShortPressKeyButton button = new ShortPressKeyButton();
        button.setText(label);
        button.setKeyCode(extKeyCode);
        if (this.getStyleClass() != null) {
            button.getStyleClass().addAll((Collection)this.getStyleClass());
        } else {
            button.setId("key-context-button");
        }
        button.setFocusTraversable(false);
        button.setPrefWidth(this.getPrefWidth());
        button.setPrefHeight(this.getPrefHeight());
        button.setOnShortPressed(this.getOnShortPressed());
        this.getContext().addButton(button);
    }
}

