/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Menu;
import javafx.scene.layout.TilePane;
import javafx.stage.Popup;

class MultiKeyPopup
extends Popup {
    public static final String DEFAULT_STYLE_CLASS = "key-context-background";
    private final TilePane buttonPane = new TilePane();
    private ObjectProperty<EventHandler<ActionEvent>> onAction;

    MultiKeyPopup() {
        this.buttonPane.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.buttonPane.setFocusTraversable(false);
        this.buttonPane.getChildren().addListener(c -> {
            while (c.next()) {
                if (c.wasPermutated() || !c.wasAdded()) continue;
                c.getAddedSubList().forEach(node -> {
                    node.setFocusTraversable(false);
                    if (node instanceof ButtonBase) {
                        ((ButtonBase)node).setOnAction(event -> this.hide());
                    }
                });
            }
        });
        this.getContent().add((Object)this.buttonPane);
        this.setAutoFix(true);
        this.setAutoHide(true);
    }

    public void addButton(Button button) {
        this.buttonPane.getChildren().add((Object)button);
        if (this.buttonPane.getChildren().size() < 6) {
            this.buttonPane.setPrefColumns(this.buttonPane.getChildren().size());
            this.buttonPane.setPrefRows(1);
        } else if (this.buttonPane.getChildren().size() == 6) {
            this.buttonPane.setPrefColumns(3);
            this.buttonPane.setPrefRows(2);
        } else if (this.buttonPane.getChildren().size() < 9) {
            this.buttonPane.setPrefColumns(4);
            this.buttonPane.setPrefRows(2);
        } else {
            this.buttonPane.setPrefColumns(5);
        }
    }

    public ObservableList<String> getStylesheets() {
        return this.buttonPane.getStylesheets();
    }

    public void setPaneStyle(String value) {
        this.buttonPane.setStyle(value);
    }

    public void show(Node node, double scale) {
        if (node == null) {
            return;
        }
        Event.fireEvent((EventTarget)this, (Event)new Event(Menu.ON_SHOWING));
        if (!this.buttonPane.getChildren().isEmpty()) {
            if (this.buttonPane.getScaleX() != scale) {
                this.buttonPane.setScaleX(scale);
                this.buttonPane.setScaleY(scale);
            }
            double offsetX = this.getWidth() / 2.0;
            double offsetY = this.getHeight() / 2.0;
            Bounds bounds = node.localToScreen(node.getBoundsInLocal());
            super.show(node, bounds.getMinX() + bounds.getWidth() / 2.0 - offsetX, bounds.getMinY() - offsetY);
            if (offsetX < 1.0 || offsetY < 1.0) {
                this.centerPosition();
            }
        }
    }

    private void centerPosition() {
        this.setX(this.getX() - this.getWidth() / 2.0);
        this.setY(this.getY() - this.getHeight() / 2.0);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final void setOnAction(EventHandler<ActionEvent> eventhandler) {
        this.onActionProperty().set(eventhandler);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        if (this.onAction == null) {
            this.onAction = new SimpleObjectProperty<EventHandler<ActionEvent>>(){

                protected void invalidated() {
                    MultiKeyPopup.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
                }
            };
        }
        return this.onAction;
    }

    public void hide() {
        if (this.isShowing()) {
            Event.fireEvent((EventTarget)this, (Event)new Event(Menu.ON_HIDING));
            super.hide();
            Event.fireEvent((EventTarget)this, (Event)new Event(Menu.ON_HIDDEN));
        }
    }
}

