/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.security.AccessController;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.input.MouseButton;
import javafx.util.Duration;
import org.comtel2000.keyboard.control.KeyButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepeatableKeyButton
extends KeyButton {
    private static final Logger logger = LoggerFactory.getLogger(RepeatableKeyButton.class);
    private static double KEY_REPEAT_RATE = 25.0;
    private static final double KEY_REPEAT_RATE_MIN = 2.0;
    private static final double KEY_REPEAT_RATE_MAX = 50.0;
    private final long REPEAT_DELAY = 40L;
    private Timeline repeatDelay;

    static {
        AccessController.doPrivileged(() -> {
            String s = System.getProperty("org.comtel2000.keyboard.repeatRate");
            if (s != null) {
                Double rate = Double.valueOf(s);
                KEY_REPEAT_RATE = rate <= 0.0 ? 0.0 : Math.min(Math.max(rate, 2.0), 50.0);
            }
            return null;
        });
    }

    RepeatableKeyButton() {
        this.getStyleClass().add((Object)"repeatable-button");
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    protected void initEventListener(double delay) {
        if (KEY_REPEAT_RATE > 0.0) {
            this.buttonDelay = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), event -> {
                this.fireShortPressed();
                this.repeatDelay.playFromStart();
            }, new KeyValue[0])});
            this.repeatDelay = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)(1000.0 / KEY_REPEAT_RATE)), event -> this.fireShortPressed(), new KeyValue[0])});
            this.repeatDelay.setCycleCount(-1);
            this.setOnDragDetected(e -> {
                logger.trace("{} drag detected", (Object)this.getKeyCode());
                this.buttonDelay.stop();
                e.consume();
            });
            this.setOnMousePressed(e -> {
                logger.trace("{} pressed", (Object)this.getKeyCode());
                if (e.getButton().equals((Object)MouseButton.PRIMARY)) {
                    if (!this.isMovable()) {
                        this.fireShortPressed();
                    }
                    this.buttonDelay.playFromStart();
                }
                e.consume();
            });
            this.setOnMouseReleased(e -> {
                logger.trace("{} released", (Object)this.getKeyCode());
                if (this.isMovable() && this.buttonDelay.getStatus() == Animation.Status.RUNNING) {
                    this.fireShortPressed();
                }
                this.buttonDelay.stop();
                this.repeatDelay.stop();
                this.setFocused(false);
                e.consume();
            });
        }
    }
}

