/*
 * Decompiled with CFR 0.152.
 */
package org.conceptoriented.bistro.server.actions;

import java.time.Duration;
import java.time.Instant;
import org.conceptoriented.bistro.core.BistroError;
import org.conceptoriented.bistro.core.Column;
import org.conceptoriented.bistro.core.Range;
import org.conceptoriented.bistro.core.Table;
import org.conceptoriented.bistro.server.Action;
import org.conceptoriented.bistro.server.Context;

public class ActionRemove
implements Action {
    protected Table table;
    protected Column column;
    protected Duration age;
    protected long size;

    @Override
    public void evaluate(Context ctx) throws BistroError {
        if (this.table == null) {
            return;
        }
        if (this.column != null && this.age != null) {
            this.removeDuration();
        } else {
            this.removeCount();
        }
    }

    protected void removeCount() {
        long toRemove = this.table.getLength() - this.size;
        if (toRemove > 0L) {
            this.table.remove(toRemove);
        }
    }

    protected void removeDuration() {
        if (this.table.getLength() == 0L) {
            return;
        }
        Instant now = Instant.now();
        Instant oldest = now.minus(this.age);
        this.table.remove(this.column, (Object)oldest);
    }

    protected void removeDurationManually() {
        Instant t;
        Duration d;
        if (this.table.getLength() == 0L) {
            return;
        }
        Instant now = Instant.now();
        long toRemove = 0L;
        Range range = this.table.getIdRange();
        for (long i = range.start; i < range.end && this.age.compareTo(d = Duration.between(t = (Instant)this.column.getValue(i), now)) <= 0; ++i) {
            ++toRemove;
        }
        if (toRemove > 0L) {
            this.table.remove(toRemove);
        }
    }

    public ActionRemove(Table table, long size) {
        this.table = table;
        this.size = size;
    }

    public ActionRemove(Table table, Column column, Duration age) {
        this.table = table;
        this.column = column;
        this.age = age;
    }
}

