/*
 * Decompiled with CFR 0.152.
 */
package org.conceptoriented.bistro.server.connectors;

import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.function.Function;
import org.conceptoriented.bistro.core.BistroError;
import org.conceptoriented.bistro.core.BistroErrorCode;
import org.conceptoriented.bistro.core.Table;
import org.conceptoriented.bistro.server.Server;
import org.conceptoriented.bistro.server.connectors.ConnectorSimulator;

public class ConnectorSimulatorFile
extends ConnectorSimulator {
    protected String path;
    protected String timestampColumn;
    protected double accelerate = 1.0;
    protected Function<String, Instant> converter = x -> Instant.parse(x);

    public void setConverter(Function<String, Instant> converter) {
        this.converter = converter;
    }

    protected Instant convert(String time) {
        return this.converter.apply(time);
    }

    @Override
    public void start() throws BistroError {
        try {
            this.load(this.path, this.timestampColumn);
        }
        catch (FileNotFoundException e) {
            throw new BistroError(BistroErrorCode.CONNECTOR_ERROR, "Error loading file.", e.getMessage());
        }
        super.start();
    }

    @Override
    public void stop() throws BistroError {
        super.stop();
        this.data = null;
        this.delays = null;
    }

    protected void load(String path, String timestampColumn) throws FileNotFoundException {
        List<String[]> lines = ConnectorSimulatorFile.readLinesFromCsvFile(path);
        String[] columnNames = lines.get(0);
        int tsColumnIndex = Arrays.asList(columnNames).indexOf(timestampColumn);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        ArrayList<Instant> timestamps = new ArrayList<Instant>();
        for (int i = 1; i < lines.size(); ++i) {
            String[] line = lines.get(i);
            Instant ts = null;
            ArrayList<String> dataLine = new ArrayList<String>();
            for (int f = 0; f < line.length; ++f) {
                String val = line[f];
                if (f == tsColumnIndex) {
                    ts = this.convert(val);
                    continue;
                }
                dataLine.add(val);
            }
            timestamps.add(ts);
            data.add(dataLine.toArray());
        }
        ArrayList<Duration> delays = new ArrayList<Duration>();
        for (int i = 1; i < timestamps.size(); ++i) {
            Duration del = Duration.between((Temporal)timestamps.get(i - 1), (Temporal)timestamps.get(i));
            long nanos = Math.round((double)del.toNanos() / this.accelerate);
            delays.add(Duration.ofNanos(nanos));
        }
        delays.add(Duration.ofMillis(0L));
        this.delays = delays;
        this.data = data;
    }

    private static List<String[]> readLinesFromCsvFile(String path) throws FileNotFoundException {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        Scanner scanner = new Scanner(new File(path));
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String[] fields = line.split(",");
            Arrays.parallelSetAll(fields, i -> fields[i].trim());
            lines.add(fields);
        }
        scanner.close();
        return lines;
    }

    public ConnectorSimulatorFile(Server server, Table table, String path, String timestampColumn, double accelerate) throws FileNotFoundException {
        super(server, table, (Duration)null, null);
        this.path = path;
        this.timestampColumn = timestampColumn;
        this.accelerate = accelerate;
    }
}

