/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.config;

import org.concordion.cubano.config.DefaultPropertiesLoader;
import org.concordion.cubano.config.DefaultPropertyLoader;
import org.concordion.cubano.config.PropertiesLoader;
import org.concordion.cubano.config.PropertyLoader;
import org.concordion.cubano.config.ProxyConfig;

public final class Config {
    private final DefaultPropertyLoader propertyLoader;
    private final ProxyConfig proxyConfig;

    public static Config getInstance() {
        return ConfigHolder.INSTANCE;
    }

    protected Config() {
        this(DefaultPropertiesLoader.getInstance());
    }

    protected Config(PropertiesLoader propertiesLoader) {
        this.propertyLoader = new DefaultPropertyLoader(propertiesLoader.getProperties());
        this.proxyConfig = new ProxyConfig(this.propertyLoader);
    }

    public String getEnvironment() {
        return this.propertyLoader.getEnvironment();
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public PropertyLoader getPropertyLoader() {
        return this.propertyLoader;
    }

    private static class ConfigHolder {
        static final Config INSTANCE = new Config();

        private ConfigHolder() {
        }
    }
}

