/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.config;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import org.concordion.cubano.config.CaselessProperties;
import org.concordion.cubano.config.PropertiesLoader;

public class DefaultPropertiesLoader
implements PropertiesLoader {
    private static final String CONFIG_FILE = "config.properties";
    private static final String USER_CONFIG_FILE = "user.properties";
    private final Properties properties;

    public static DefaultPropertiesLoader getInstance() {
        return DPHolder.INSTANCE;
    }

    protected DefaultPropertiesLoader(String properties, String userProperties) {
        this.properties = new CaselessProperties();
        this.loadFromString(properties);
        this.loadFromString(userProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultPropertiesLoader() {
        Class<DefaultPropertiesLoader> clazz = DefaultPropertiesLoader.class;
        synchronized (DefaultPropertiesLoader.class) {
            this.properties = new CaselessProperties();
            this.loadFile(CONFIG_FILE);
            if (new File(USER_CONFIG_FILE).exists()) {
                this.loadFile(USER_CONFIG_FILE);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void loadFile(String filename) {
        try {
            this.loadFromString(new String(Files.readAllBytes(Paths.get(filename, new String[0]))));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read properties file " + filename, e);
        }
    }

    private void loadFromString(String content) {
        try {
            this.properties.load(new StringReader(content.replace("\\", "\\\\")));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load properties.", e);
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private static class DPHolder {
        static final DefaultPropertiesLoader INSTANCE = new DefaultPropertiesLoader();

        private DPHolder() {
        }
    }
}

