/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import org.concordion.cubano.driver.http.Family;
import org.concordion.cubano.driver.http.HttpEasyDefaults;
import org.concordion.cubano.driver.http.HttpEasyReader;
import org.concordion.cubano.driver.http.HttpResponseException;
import org.concordion.cubano.driver.http.LogWriter;
import org.concordion.cubano.driver.http.SSLUtilities;
import org.concordion.cubano.driver.http.dataWriter.DataWriter;
import org.concordion.cubano.driver.http.dataWriter.Field;
import org.concordion.cubano.driver.http.dataWriter.FormDataWriter;
import org.concordion.cubano.driver.http.dataWriter.FormUrlEncodedDataWriter;
import org.concordion.cubano.driver.http.dataWriter.RawDataWriter;
import org.concordion.cubano.driver.http.logging.LogManager;

public class HttpEasy {
    List<Integer> ignoreResponseCodes = new ArrayList<Integer>();
    List<Family> ignoreResponseFamily = new ArrayList<Family>();
    private Optional<String> authUser = Optional.empty();
    private Optional<String> authPassword = Optional.empty();
    private Optional<String> baseUrl = Optional.empty();
    private String path = "";
    private StringBuilder query = new StringBuilder();
    private String startToken = "{";
    private String endToken = "}";
    private Object[] urlParams = new Object[0];
    private DataContentType dataContentType = DataContentType.AUTO_SELECT;
    private Object rawData = null;
    private String rawFileName = null;
    private MediaType rawDataMediaType = null;
    private Map<String, Object> headers = new LinkedHashMap<String, Object>();
    private List<Field> fields = new ArrayList<Field>();
    private Integer timeout = null;
    private LogManager logManager = null;
    private Optional<LogWriter> logWriter = Optional.empty();
    private Optional<Boolean> logRequestDetails = Optional.empty();
    private Optional<Boolean> trustAllCertificates = Optional.empty();
    private Optional<Boolean> trustAllHosts = Optional.empty();
    private boolean includeEmptyValues = false;

    public static HttpEasyDefaults withDefaults() {
        return new HttpEasyDefaults();
    }

    public static HttpEasy request() {
        return new HttpEasy();
    }

    public HttpEasy header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpEasy authorization(String username, String password) {
        this.authUser = Optional.of(username);
        this.authPassword = Optional.of(password);
        return this;
    }

    public HttpEasy setTimeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public HttpEasy includeEmptyValues(boolean includeEmptyValues) {
        this.includeEmptyValues = includeEmptyValues;
        return this;
    }

    public HttpEasy baseUrl(String url) {
        this.baseUrl = Optional.of(url);
        return this;
    }

    public HttpEasy trustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = Optional.of(trustAllCertificates);
        return this;
    }

    public HttpEasy trustAllHosts(boolean trustAllHosts) {
        this.trustAllHosts = Optional.of(trustAllHosts);
        return this;
    }

    public HttpEasy path(String path) {
        this.path = path;
        return this;
    }

    public HttpEasy query(String query) {
        this.query = new StringBuilder(query);
        return this;
    }

    public HttpEasy queryParam(String name, Object value) {
        if (this.skipEmptyParameter(name, value)) {
            return this;
        }
        if (this.query.length() > 0) {
            this.query.append("&");
        }
        this.query.append(name).append("=").append(value.toString());
        return this;
    }

    public HttpEasy logRequestDetails() {
        this.logRequestDetails = Optional.of(true);
        return this;
    }

    public HttpEasy parameterTokens(String startToken, String endToken) {
        this.startToken = startToken;
        this.endToken = endToken;
        return this;
    }

    public HttpEasy urlParameters(Object ... pathParams) {
        this.urlParams = pathParams;
        return this;
    }

    public HttpEasy dataForm() {
        if (this.dataContentType != DataContentType.AUTO_SELECT) {
            throw new InvalidParameterException("Content type cannot be changed once set");
        }
        this.dataContentType = DataContentType.FORM_DATA;
        return this;
    }

    public HttpEasy urlEncodedForm() {
        if (this.dataContentType != DataContentType.AUTO_SELECT) {
            throw new InvalidParameterException("Content type cannot be changed once set");
        }
        this.dataContentType = DataContentType.X_WWW_FORM_URLENCODED;
        return this;
    }

    public HttpEasy field(String name, Object value) {
        return this.field(name, value, null);
    }

    public HttpEasy field(String name, Object value, MediaType type) {
        return this.field(name, value, type, null);
    }

    public HttpEasy field(String name, File value, MediaType type) {
        return this.field(name, value, type, null);
    }

    public HttpEasy field(String name, InputStream value, MediaType type, String fileName) {
        return this.field(name, (Object)value, type, fileName);
    }

    public HttpEasy field(String name, Object value, MediaType type, String fileName) {
        if (this.rawData != null) {
            throw new InvalidParameterException("Data cannot be used at the same time as fields");
        }
        if (value instanceof InputStream && (fileName == null || fileName.isEmpty())) {
            throw new InvalidParameterException("InputStream must provide filename");
        }
        if (this.skipEmptyParameter(name, value)) {
            return this;
        }
        this.fields.add(new Field(name, value, type, fileName));
        return this;
    }

    public HttpEasy data(Object data, MediaType mediaType) {
        return this.data(data, mediaType, null);
    }

    public HttpEasy data(Object data, MediaType mediaType, String fileName) {
        if (this.rawData != null) {
            throw new InvalidParameterException("Only a single data value can be added");
        }
        if (data instanceof InputStream && (fileName == null || fileName.isEmpty())) {
            throw new InvalidParameterException("InputStream must provide filename");
        }
        if (this.dataContentType != DataContentType.AUTO_SELECT) {
            throw new InvalidParameterException("Content type cannot be changed once set");
        }
        this.dataContentType = DataContentType.RAW;
        this.rawDataMediaType = mediaType;
        this.rawData = data;
        this.rawFileName = fileName;
        return this;
    }

    public HttpEasy doNotFailOn(Integer ... reponseCodes) {
        this.ignoreResponseCodes.addAll(Arrays.asList(reponseCodes));
        return this;
    }

    public HttpEasy doNotFailOn(Family ... responseFamily) {
        this.ignoreResponseFamily.addAll(Arrays.asList(responseFamily));
        return this;
    }

    public HttpEasy withLogWriter(LogWriter logWriter) {
        this.logWriter = Optional.of(logWriter);
        return this;
    }

    public HttpEasyReader get() throws HttpResponseException, IOException {
        return new HttpEasyReader(this.getConnectionMethod("GET"), this);
    }

    public HttpEasyReader head() throws HttpResponseException, IOException {
        return new HttpEasyReader(this.getConnectionMethod("HEAD"), this);
    }

    public HttpEasyReader post() throws HttpResponseException, IOException {
        return new HttpEasyReader(this.getConnectionMethod("POST"), this);
    }

    public HttpEasyReader put() throws HttpResponseException, IOException {
        return new HttpEasyReader(this.getConnectionMethod("PUT"), this);
    }

    public HttpEasyReader delete() throws HttpResponseException, IOException {
        return new HttpEasyReader(this.getConnectionMethod("DELETE"), this);
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection getConnectionMethod(String requestMethod) throws IOException {
        int fifteenSeconds = 15000;
        DataWriter dataWriter = null;
        URL url = this.getURL();
        HttpURLConnection connection = this.getConnection(url);
        this.setHeaders(connection);
        connection.setRequestMethod(requestMethod);
        connection.setUseCaches(false);
        if (this.timeout != null) {
            connection.setConnectTimeout(this.timeout);
            connection.setReadTimeout(this.timeout);
        } else {
            connection.setConnectTimeout(fifteenSeconds);
        }
        connection.setInstanceFollowRedirects(false);
        if (requestMethod.equals("POST") || requestMethod.equals("PUT")) {
            dataWriter = this.getDataWriter(url, connection);
            connection.setDoOutput(true);
        } else if (this.fields.size() > 0) {
            throw new IllegalStateException("Fields have been specified but the method " + requestMethod + " will not use them, try POST or PUT instead.");
        }
        this.logManager = new LogManager(this.logWriter.orElse(HttpEasyDefaults.getDefaultLogWriter()), this.logRequestDetails.orElse(HttpEasyDefaults.getLogRequestDetails()));
        try {
            this.logRequest(connection, requestMethod, url);
            connection.connect();
            if (dataWriter != null) {
                dataWriter.write(this.logManager);
            }
        }
        finally {
            if (this.logManager.isLogRequestDetails()) {
                this.logManager.flushRequest();
            } else {
                this.logManager.flushInfo();
            }
        }
        return connection;
    }

    private boolean skipEmptyParameter(String name, Object value) {
        if (name == null || name.isEmpty()) {
            return true;
        }
        if (!this.includeEmptyValues) {
            if (value == null) {
                return true;
            }
            if (value instanceof String && ((String)value).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private void logRequest(HttpURLConnection connection, String requestMethod, URL url) {
        String user = this.authUser.orElse(HttpEasyDefaults.getAuthUser());
        String authMsg = "";
        if (user != null && !user.isEmpty()) {
            authMsg = " as user '" + user + "'";
        }
        String logUrl = url.toString();
        for (String key : HttpEasyDefaults.getSensitiveParameters()) {
            logUrl = logUrl.replaceFirst("(?i)(?<=\\?|&|^)" + key + "=.*?(?=$|&)", key + "=*****");
        }
        this.logManager.info("Sending {0}{1} to {2}", requestMethod, authMsg, logUrl);
        if (this.logManager.isLogRequestDetails()) {
            this.logManager.getBuffer().write("Request Method: ").writeLine(connection.getRequestMethod());
            this.logManager.getBuffer().write("Request URI: ").writeLine(connection.getURL().toString());
            this.logManager.getBuffer().write("Proxy: ").writeLine(HttpEasyDefaults.getProxy(url).toString());
            if (!Strings.isNullOrEmpty((String)user)) {
                this.logManager.getBuffer().write("Basic Authorization User: ").writeLine(user);
            }
            if (this.query.length() > 0) {
                this.logManager.getBuffer().writeLine("Query Params:");
                for (String value : this.query.toString().split("&")) {
                    for (String key : HttpEasyDefaults.getSensitiveParameters()) {
                        value = value.replaceFirst("(?i)(?<=\\?|&|^)" + key + "=.*?(?=$|&)", key + "=*****");
                    }
                    this.logManager.getBuffer().writeIndentedLine(value);
                }
            }
            this.logManager.getBuffer().writeLine("Request Headers:");
            ArrayList<String> headers = new ArrayList<String>();
            for (Map.Entry<String, List<String>> header : connection.getRequestProperties().entrySet()) {
                for (String value : header.getValue()) {
                    if (header.getKey() == null || header.getKey().isEmpty()) {
                        this.logManager.getBuffer().writeIndentedLine(value);
                        continue;
                    }
                    headers.add(String.format("%s: %s", header.getKey(), value));
                }
            }
            headers.sort((h1, h2) -> h1.compareTo((String)h2));
            for (String value : headers) {
                this.logManager.getBuffer().writeIndentedLine(value);
            }
        }
    }

    private DataWriter getDataWriter(URL url, HttpURLConnection connection) throws UnsupportedEncodingException {
        DataWriter dataWriter = null;
        if (this.dataContentType == DataContentType.AUTO_SELECT && !this.fields.isEmpty()) {
            this.dataContentType = this.fieldsHasFile() ? DataContentType.FORM_DATA : DataContentType.X_WWW_FORM_URLENCODED;
        }
        switch (this.dataContentType) {
            case RAW: {
                dataWriter = new RawDataWriter(connection, this.rawData, this.rawDataMediaType, this.rawFileName);
                break;
            }
            case FORM_DATA: {
                dataWriter = new FormDataWriter(connection, url.getQuery(), this.fields);
                break;
            }
            case X_WWW_FORM_URLENCODED: {
                dataWriter = new FormUrlEncodedDataWriter(connection, url.getQuery(), this.fields);
                break;
            }
            case AUTO_SELECT: {
                break;
            }
            default: {
                throw new InvalidParameterException(this.dataContentType.toString() + " is unknown");
            }
        }
        return dataWriter;
    }

    private boolean fieldsHasFile() {
        for (Field field : this.fields) {
            if (field.value instanceof File) {
                return true;
            }
            if (!(field.value instanceof InputStream)) continue;
            return true;
        }
        return false;
    }

    private HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection connection;
        Proxy useProxy = HttpEasyDefaults.getProxy(url);
        if (url.getProtocol().equalsIgnoreCase("https")) {
            connection = (HttpsURLConnection)url.openConnection(useProxy);
            if (this.trustAllCertificates.orElse(HttpEasyDefaults.isTrustAllCertificates()).booleanValue()) {
                try {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(SSLUtilities.getTrustAllCertificatesSocketFactory());
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new IOException("Unable to trust all certificates", e);
                }
            }
            if (this.trustAllHosts.orElse(HttpEasyDefaults.isTrustAllHosts()).booleanValue()) {
                ((HttpsURLConnection)connection).setHostnameVerifier(SSLUtilities.getTrustAllHostsVerifier());
            }
        } else {
            connection = (HttpURLConnection)url.openConnection(useProxy);
        }
        return connection;
    }

    private URL getURL() throws MalformedURLException {
        String spec = "";
        if (!this.containsProtol(this.path) && !this.containsProtol(this.query.toString())) {
            spec = this.baseUrl.orElse(HttpEasyDefaults.getBaseUrl());
        }
        spec = this.appendSegmentToUrl(spec, this.path, "/");
        spec = this.appendSegmentToUrl(spec, this.query.toString(), "?");
        URL url = new URL(spec = this.replaceParameters(spec));
        if (url.getUserInfo() != null) {
            String authString = url.getUserInfo();
            int index = authString.indexOf(":");
            if (index > 0) {
                this.authUser = Optional.of(authString.substring(0, index));
                this.authPassword = Optional.of(authString.substring(index + 1));
            }
            spec = url.toExternalForm().replace(url.getUserInfo() + "@", "");
            url = new URL(spec);
        }
        return url;
    }

    private boolean containsProtol(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        return url.contains("//");
    }

    private String appendSegmentToUrl(String url, String segment, String join) {
        if (url == null || url.isEmpty()) {
            return segment;
        }
        if (segment == null || segment.isEmpty()) {
            return url;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!segment.startsWith(join)) {
            segment = join + segment;
        }
        return url + segment;
    }

    private String replaceParameters(String url) {
        int index = 0;
        int param = 0;
        String currentParameter = "";
        while ((index = url.indexOf(this.startToken, index)) > 0) {
            if (param < this.urlParams.length) {
                currentParameter = String.valueOf(this.urlParams[param]);
                ++param;
            }
            if (currentParameter.contains(" ")) {
                throw new IllegalArgumentException("URL Parameter [" + param + "] cannot contain a space");
            }
            url = url.substring(0, index) + currentParameter + url.substring(url.indexOf(this.endToken) + 1);
        }
        return url;
    }

    private void setHeaders(HttpURLConnection connection) throws UnsupportedEncodingException {
        this.setProxyAuthorizationHeader(connection);
        this.setAuthorizationHeader(connection);
        for (Map.Entry<String, Object> header : this.headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), String.valueOf(header.getValue()));
        }
    }

    String getAuthorization() {
        String user = this.authUser.orElse(HttpEasyDefaults.getAuthUser());
        String password = this.authPassword.orElse(HttpEasyDefaults.getAuthPassword());
        if (user == null || user.isEmpty() || password == null || password.isEmpty()) {
            return null;
        }
        return user + ":" + password;
    }

    private void setAuthorizationHeader(HttpURLConnection connection) {
        String authString = this.getAuthorization();
        if (authString != null) {
            connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(authString.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private void setProxyAuthorizationHeader(HttpURLConnection connection) {
        if (HttpEasyDefaults.getProxyUser() == null || HttpEasyDefaults.getProxyUser().isEmpty()) {
            return;
        }
        if (HttpEasyDefaults.getProxyPassword() == null || HttpEasyDefaults.getProxyPassword().isEmpty()) {
            return;
        }
        String usernameAndPassword = HttpEasyDefaults.getProxyUser() + ":" + HttpEasyDefaults.getProxyPassword();
        String proxyAuthString = "Basic " + Base64.getEncoder().encodeToString(usernameAndPassword.getBytes(StandardCharsets.UTF_8));
        connection.setRequestProperty("Proxy-Authorization", proxyAuthString);
    }

    private static enum DataContentType {
        AUTO_SELECT,
        RAW,
        X_WWW_FORM_URLENCODED,
        FORM_DATA;

    }
}

