/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.concordion.cubano.driver.http.Family;
import org.concordion.cubano.driver.http.HttpEasy;
import org.concordion.cubano.driver.http.HttpResponseException;
import org.concordion.cubano.driver.http.JsonReader;
import org.concordion.cubano.driver.http.XmlReader;
import org.concordion.cubano.driver.http.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class HttpEasyReader {
    private HttpURLConnection connection;
    private String returned = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpEasyReader.class);

    public HttpEasyReader(HttpURLConnection connection, HttpEasy request) throws HttpResponseException, IOException {
        this.connection = connection;
        Family responseFamily = this.getResponseCodeFamily();
        this.logResponse(request);
        if (responseFamily != Family.SUCCESSFUL) {
            if (this.listContains(request.ignoreResponseCodes, this.getResponseCode())) {
                return;
            }
            if (this.listContains(request.ignoreResponseFamily, responseFamily)) {
                return;
            }
            throw new HttpResponseException(this.getResponseCode(), "Server returned HTTP response code " + connection.getResponseCode() + ": " + connection.getResponseMessage() + "\r\nResponse Content: " + this.asString());
        }
    }

    private void logResponse(HttpEasy request) throws IOException {
        if (!request.getLogManager().isLogRequestDetails()) {
            return;
        }
        LogManager logger = request.getLogManager();
        ArrayList<String> headers = new ArrayList<String>();
        logger.getBuffer().writeLine("Response Headers:");
        for (Map.Entry<String, List<String>> header : this.getConnection().getHeaderFields().entrySet()) {
            for (String value : header.getValue()) {
                if (header.getKey() == null || header.getKey().isEmpty()) {
                    logger.getBuffer().writeIndentedLine(value);
                    continue;
                }
                headers.add(String.format("%s: %s", header.getKey(), value));
            }
        }
        headers.sort((h1, h2) -> h1.compareTo((String)h2));
        for (String value : headers) {
            logger.getBuffer().writeIndentedLine(value);
        }
        logger.getBuffer().writeLine("Response:");
        logger.getBuffer().write(this.formatAsReaderUsingContentType(this.getConnection().getContentType()));
        logger.flushResponse();
    }

    private String formatAsReaderUsingContentType(String contentType) {
        if (contentType != null) {
            try {
                if (contentType.contains("json")) {
                    return new JsonReader(this.asString()).asPrettyString();
                }
                if (contentType.contains("xml")) {
                    return new XmlReader(this.asString()).asPrettyString();
                }
                if (contentType.contains("text")) {
                    return this.asString();
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("Unable to parse response using ContentType '%s', Error Msg '%s'", contentType, e.getMessage()));
            }
        }
        return String.format("Unable to display response for content of type '%s'", contentType);
    }

    private <T> boolean listContains(List<T> array, T targetValue) {
        for (T s : array) {
            if (!s.equals(targetValue)) continue;
            return true;
        }
        return false;
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public Family getResponseCodeFamily() throws IOException {
        return Family.familyOf(this.connection.getResponseCode());
    }

    public String asString() throws IOException {
        if (this.returned != null) {
            return this.returned;
        }
        if (this.connection.getResponseCode() < 400) {
            return this.asString(this.connection.getInputStream());
        }
        return this.asString(this.connection.getErrorStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String asString(InputStream stream) throws IOException {
        if (stream == null) {
            this.returned = "";
            return this.returned;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            this.returned = sb.toString().trim();
        }
        finally {
            this.connection.disconnect();
        }
        return this.returned;
    }

    public JsonReader getJsonReader() throws IOException {
        return new JsonReader(this.asString());
    }

    public XmlReader getXmlReader() throws ParserConfigurationException, SAXException, IOException {
        return new XmlReader(this.asString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadFile(String saveDir) throws IOException {
        int bufferSize = 4096;
        String fileName = this.parseDispositionFilename(this.connection.getHeaderField("Content-Disposition"));
        if (fileName == null) {
            fileName = this.connection.getURL().getPath();
            if (this.connection.getURL().getQuery() != null || fileName == null || fileName.isEmpty()) {
                throw new IOException("Unable to get fileName from either Content-Disposition header or url:" + this.connection.getURL());
            }
        }
        fileName = new File(fileName).getName();
        File folder = new File(saveDir);
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("Unable to create the folder " + folder.getPath());
        }
        File saveFile = new File(saveDir, fileName);
        try (InputStream inputStream = this.connection.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(saveFile);){
            int bytesRead = -1;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        finally {
            this.connection.disconnect();
        }
        return saveFile;
    }

    private String parseDispositionFilename(String dispositionString) {
        return HttpEasyReader.parseForAttribute("filename", dispositionString);
    }

    public static String parseForAttribute(String attribute, String parseString) {
        int endQuoteIndex;
        if (parseString == null) {
            return null;
        }
        int nameIndex = parseString.indexOf(attribute + "=\"");
        if (nameIndex != -1 && (endQuoteIndex = parseString.indexOf("\"", nameIndex + attribute.length() + 3)) != -1) {
            return parseString.substring(nameIndex + attribute.length() + 2, endQuoteIndex);
        }
        return null;
    }

    public String getResponseHeaderField(String name) {
        return this.connection.getHeaderField(name);
    }

    public List<String> getResponseHeaderFields(String name) {
        return this.connection.getHeaderFields().get(name);
    }
}

