/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.concordion.cubano.driver.http.ResponseReader;

public class JsonReader
implements ResponseReader {
    private final JsonElement json;
    private static final Pattern CHECK_FOR_DOT = Pattern.compile("(?<!\\\\)\\.");

    public JsonReader(String json) {
        this.json = new JsonParser().parse(json);
    }

    public JsonReader(JsonElement element) {
        this.json = element;
    }

    @Override
    public String asPrettyString() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(this.json);
    }

    public JsonElement asJson() throws IOException {
        return this.json;
    }

    public String getAsString(String path) {
        JsonElement element = this.jsonPath(path);
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return element.getAsString();
    }

    public String getAsString(JsonElement node, String path) {
        JsonElement element = this.jsonPath(node, path);
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return element.getAsString().trim();
    }

    public JsonArray getAsJsonArray(String path) {
        JsonElement element = this.jsonPath(path);
        if (element == null || !element.isJsonArray()) {
            return new JsonArray();
        }
        return element.getAsJsonArray();
    }

    public JsonArray getAsJsonArray(JsonElement node, String path) {
        JsonElement element = this.jsonPath(node, path);
        if (element == null || !element.isJsonArray()) {
            return new JsonArray();
        }
        return element.getAsJsonArray();
    }

    public JsonElement jsonPath(String path) {
        return this.jsonPath(this.json, path);
    }

    public JsonElement jsonPath(JsonElement json, String path) {
        JsonElement newJson;
        if (json == null) {
            return null;
        }
        if (!this.hasNextJsonPathElement(path)) {
            return json.getAsJsonObject().get(this.removeEscapeCharacter(path));
        }
        String next = this.getNextJsonPathElement(path);
        if (next.endsWith("]")) {
            int pos = next.lastIndexOf(91);
            String index = next.substring(pos + 1, next.length() - 1);
            next = next.substring(0, pos);
            newJson = json.getAsJsonObject().get(next).getAsJsonArray().get(Integer.parseInt(index));
        } else {
            newJson = json.getAsJsonObject().get(next);
        }
        return this.jsonPath(newJson, this.getNewJsonPath(path));
    }

    private String removeEscapeCharacter(String path) {
        return path.replace("\\.", ".");
    }

    private boolean hasNextJsonPathElement(String path) {
        Matcher matcher = CHECK_FOR_DOT.matcher(path);
        return matcher.find();
    }

    private String getNextJsonPathElement(String path) {
        Matcher matcher = CHECK_FOR_DOT.matcher(path);
        if (matcher.find()) {
            return this.removeEscapeCharacter(path.substring(0, matcher.start()));
        }
        return path;
    }

    private String getNewJsonPath(String path) {
        Matcher matcher = CHECK_FOR_DOT.matcher(path);
        if (matcher.find()) {
            return path.substring(matcher.end());
        }
        return "";
    }

    public <T> T fromJson(Class<T> type) throws IOException {
        return (T)new Gson().fromJson(this.json, type);
    }

    public <T> T fromJson(Type returnType) throws JsonSyntaxException {
        return (T)new Gson().fromJson(this.json, returnType);
    }

    public <T> T fromJson(Gson builder, Type returnType) {
        return (T)builder.fromJson(this.json, returnType);
    }
}

