/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.concordion.cubano.driver.http.ResponseReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlReader
implements ResponseReader {
    private final Document document;

    public XmlReader(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        InputSource src = new InputSource();
        src.setCharacterStream(new StringReader(xml));
        this.document = builder.parse(src);
    }

    public XmlReader(Node node) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this(XmlReader.convertXmlNodeToString(node));
    }

    private static String convertXmlNodeToString(Node node) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource domSource = new DOMSource(node);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(domSource, sr);
        return sw.toString();
    }

    public Object evaluate(String expression, QName returnType) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return xPath.evaluate(expression, this.document, returnType);
    }

    public String textContent(String selector) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Node node = (Node)this.evaluate(selector, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    @Override
    public String asPrettyString() {
        return XmlReader.prettyFormat(this.getXmlString(this.document), 2);
    }

    public static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Throwable t) {
            return input;
        }
    }

    private String getXmlString(Node node) {
        try {
            DOMSource domSource = new DOMSource(node);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            return sw.toString();
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)this.document.getImplementation());
            LSSerializer lsSerializer = domImplementation.createLSSerializer();
            return lsSerializer.writeToString(this.document);
        }
    }

    private boolean isNodeNamed(Node node, String name) {
        String nodeName = node.getNodeName();
        int index = nodeName.indexOf(":");
        if (index >= 0) {
            nodeName = nodeName.substring(index + 1);
        }
        return nodeName.equalsIgnoreCase(name);
    }

    public <T> T from(Class<T> clazz) throws JAXBException {
        Node node;
        Node parse = this.document;
        if (this.document.hasChildNodes() && this.isNodeNamed(node = this.document.getFirstChild(), "Envelope")) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!this.isNodeNamed(child, "Body")) continue;
                parse = child.getFirstChild();
                break;
            }
        }
        StringReader stream = new StringReader(this.getXmlString(parse));
        JAXBContext jaxbc = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbc.createUnmarshaller();
        Object result = unmarshaller.unmarshal((Reader)stream);
        return (T)result;
    }
}

