/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http.dataWriter;

import com.google.common.net.MediaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.concordion.cubano.driver.http.HttpEasyDefaults;
import org.concordion.cubano.driver.http.dataWriter.DataWriter;
import org.concordion.cubano.driver.http.dataWriter.Field;
import org.concordion.cubano.driver.http.logging.LogManager;

public class FormDataWriter
implements DataWriter {
    private final HttpURLConnection connection;
    private final List<Field> fields;
    private final String boundary = "FormBoundary" + System.currentTimeMillis();
    private OutputStream outputStream;
    private PrintWriter writer = null;
    private LogManager logger = null;
    private static final String NEW_LINE = "\r\n";

    public FormDataWriter(HttpURLConnection connection, String query, List<Field> fields) throws UnsupportedEncodingException {
        this.connection = connection;
        this.fields = fields;
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogManager logger) throws IOException {
        this.logger = logger;
        this.outputStream = this.connection.getOutputStream();
        try {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8), true);
            if (logger.isLogRequestDetails()) {
                logger.getBuffer().writeLine("Request Content (multipart/form-data):");
            } else {
                logger.getBuffer().setIndentLevel(1).writeLine("With multipart/form-data content:");
            }
            for (Field field : this.fields) {
                if (field.value instanceof File) {
                    this.addFilePart(field.name, (File)field.value, field.type);
                    continue;
                }
                if (field.value instanceof InputStream) {
                    this.addFilePart(field.name, (InputStream)field.value, field.type, field.fileName);
                    continue;
                }
                this.addFormField(field.name, field.value);
            }
            this.writeFinalBoundary();
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }

    private void writeFieldBoundary() {
        StringBuilder buf = new StringBuilder();
        buf.append("--").append(this.boundary).append(NEW_LINE);
        this.logger.getBuffer().writeIndented(buf.toString());
        this.writer.append(buf);
    }

    private void writeFinalBoundary() {
        StringBuilder buf = new StringBuilder();
        buf.append("--").append(this.boundary).append("--").append(NEW_LINE);
        this.logger.getBuffer().writeIndented(buf.toString());
        this.writer.append(buf);
    }

    private void addFormField(String name, Object value) {
        StringBuilder buf = new StringBuilder();
        this.writeFieldBoundary();
        buf.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(NEW_LINE);
        buf.append(NEW_LINE);
        this.logger.getBuffer().writeIndentedLines(buf.toString());
        if (HttpEasyDefaults.getSensitiveParameters().contains(name)) {
            this.logger.getBuffer().writeLine("*****");
        } else {
            this.logger.getBuffer().writeLine(String.valueOf(value));
        }
        buf.append(String.valueOf(value)).append(NEW_LINE);
        this.writer.append(buf);
        this.writer.flush();
    }

    private void addFilePart(String fieldName, File uploadFile, MediaType type) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(uploadFile);){
            this.addFilePart(fieldName, inputStream, type, uploadFile.getName());
        }
    }

    private void addFilePart(String fieldName, InputStream inputStream, MediaType type, String fileName) throws IOException {
        StringBuilder buf = new StringBuilder();
        this.writeFieldBoundary();
        buf.append("Content-Disposition: form-data; name=\"").append(fieldName).append("\"; filename=\"").append(fileName).append("\"").append(NEW_LINE);
        if (type == null) {
            buf.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(fileName)).append(NEW_LINE);
        } else {
            buf.append("Content-Type: ").append(type.toString()).append(NEW_LINE);
        }
        buf.append(NEW_LINE);
        this.logger.getBuffer().writeIndentedLines(buf.toString());
        this.logger.getBuffer().writeLine("... Content of file ").write(fileName).writeLine(" ...");
        this.writer.append(buf);
        this.writer.flush();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        this.writer.append(NEW_LINE);
        this.writer.flush();
    }
}

