/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http.dataWriter;

import com.google.common.net.MediaType;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import org.concordion.cubano.driver.http.dataWriter.DataWriter;
import org.concordion.cubano.driver.http.logging.LogManager;

public class RawDataWriter
implements DataWriter {
    private HttpURLConnection connection;
    private String mediaType;
    private byte[] postEndcoded = null;
    private File uploadFile = null;
    private InputStream uploadStream = null;
    private String uploadFileName;

    public RawDataWriter(HttpURLConnection connection, Object rawData, MediaType rawDataMediaType, String fileName) {
        this.connection = connection;
        this.mediaType = rawDataMediaType.toString();
        if (rawData instanceof File) {
            this.uploadFile = (File)rawData;
            connection.setRequestProperty("Content-Type", rawDataMediaType.toString());
            connection.setRequestProperty("Content-Length", Long.toString(this.uploadFile.length()));
            connection.setFixedLengthStreamingMode(this.uploadFile.length());
        } else if (rawData instanceof InputStream) {
            this.uploadStream = (InputStream)rawData;
            this.uploadFileName = fileName;
            connection.setRequestProperty("Content-Type", rawDataMediaType.toString());
        } else {
            this.postEndcoded = String.valueOf(rawData).getBytes(StandardCharsets.UTF_8);
            connection.setRequestProperty("charset", StandardCharsets.UTF_8.name());
            connection.setRequestProperty("Content-Type", rawDataMediaType.toString());
            connection.setRequestProperty("Content-Length", Integer.toString(this.postEndcoded.length));
        }
    }

    @Override
    public void write(LogManager logger) throws IOException {
        if (logger.isLogRequestDetails()) {
            logger.getBuffer().writeLine("Request Content (" + this.mediaType + "):");
        } else {
            logger.getBuffer().setIndentLevel(1).writeLine("With " + this.mediaType + " content:");
        }
        if (this.uploadFile != null) {
            logger.getBuffer().writeIndented("File: ").writeLine(this.uploadFile.getAbsolutePath());
            try (FileInputStream inputStream = new FileInputStream(this.uploadFile);){
                this.write(inputStream);
            }
        }
        if (this.uploadStream != null) {
            logger.getBuffer().writeIndented("File: ").writeLine(this.uploadFileName);
            long length = this.write(this.uploadStream);
            this.connection.setRequestProperty("Content-Length", Long.toString(length));
        } else {
            logger.getBuffer().writeIndentedLines(new String(this.postEndcoded, StandardCharsets.UTF_8));
            try (DataOutputStream wr = new DataOutputStream(this.connection.getOutputStream());){
                wr.write(this.postEndcoded);
            }
        }
    }

    private long write(InputStream inputStream) throws IOException {
        long length = 0L;
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        OutputStream outputStream = this.connection.getOutputStream();
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
            length += (long)bytesRead;
        }
        outputStream.flush();
        return length;
    }
}

