/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http.logging;

public class LogBuffer {
    private static final String NEW_LINE = System.lineSeparator();
    private static final String TAB = "  ";
    private StringBuilder buffer = new StringBuilder();
    private int indentLevel = 0;

    public LogBuffer setIndentLevel(int level) {
        this.indentLevel = level;
        return this;
    }

    private void indent() {
        if (this.buffer.length() == 0 || this.bufferEndsWith(NEW_LINE)) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.buffer.append(TAB);
            }
        }
    }

    public LogBuffer write(String str) {
        this.indent();
        this.buffer.append(str);
        return this;
    }

    public LogBuffer writeLine(String str) {
        this.indent();
        this.buffer.append(str).append(NEW_LINE);
        return this;
    }

    public LogBuffer writeIndented(String str) {
        this.indent();
        this.buffer.append(TAB).append(str);
        return this;
    }

    public LogBuffer writeIndentedLine(String str) {
        this.indent();
        this.buffer.append(TAB).append(str);
        if (!this.bufferEndsWith(NEW_LINE)) {
            this.buffer.append(NEW_LINE);
        }
        return this;
    }

    public LogBuffer writeIndentedLines(String str) {
        String indent = TAB;
        for (int i = 0; i < this.indentLevel; ++i) {
            indent = indent + TAB;
        }
        this.buffer.append(indent).append(str.replace(NEW_LINE, NEW_LINE + indent));
        if (!this.bufferEndsWith(NEW_LINE + indent)) {
            this.buffer.append(NEW_LINE);
        }
        return this;
    }

    void trimNewLine() {
        if (this.bufferEndsWith(NEW_LINE)) {
            this.buffer.setLength(this.buffer.length() - NEW_LINE.length());
        }
    }

    boolean bufferEndsWith(String str) {
        return this.buffer.substring(this.buffer.length() - str.length()).equals(str);
    }

    public int length() {
        return this.buffer.length();
    }

    public String toString() {
        return this.buffer.toString();
    }
}

