/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import org.concordion.cubano.driver.web.BasePageObject;
import org.concordion.cubano.driver.web.SeleniumEventLogger;
import org.concordion.cubano.driver.web.SeleniumScreenshotTaker;
import org.concordion.cubano.driver.web.config.WebDriverConfig;
import org.concordion.cubano.driver.web.pagefactory.PageObjectAwareHtmlElementsLoader;
import org.concordion.cubano.driver.web.provider.BrowserProvider;
import org.concordion.cubano.driver.web.provider.RemoteBrowserProvider;
import org.concordion.ext.ScreenshotTaker;
import org.concordion.slf4j.ext.ReportLoggerFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser
implements Closeable {
    public static final String DEFAULT = "DEFAULT";
    private static final Logger LOGGER = LoggerFactory.getLogger(Browser.class);
    private WebDriver wrappedDriver = null;
    private EventFiringWebDriver eventFiringDriver = null;
    private SeleniumEventLogger eventListener = null;
    private SessionId sessionId = null;
    private BrowserProvider browserProvider = null;
    private static Class<? extends ScreenshotTaker> screenshotTaker = SeleniumScreenshotTaker.class;

    public Browser() {
    }

    public Browser(BrowserProvider browserProvider) {
        this.browserProvider = browserProvider;
    }

    public boolean isRemoteDriver() {
        return this.browserProvider instanceof RemoteBrowserProvider;
    }

    public boolean isOpen() {
        return this.getActiveDriver() != null;
    }

    public WebDriver getWrappedDriver() {
        return this.wrappedDriver;
    }

    public WebDriver getDriver() {
        if (!this.isOpen()) {
            this.open();
        }
        this.registerScreenshotTaker();
        return this.getActiveDriver();
    }

    public void setDriver(WebDriver driver) {
        if (WebDriverConfig.getInstance().isEventLoggingEnabled()) {
            this.eventFiringDriver.unregister((WebDriverEventListener)this.eventListener);
            this.eventFiringDriver = new EventFiringWebDriver(driver);
            this.eventFiringDriver.register((WebDriverEventListener)this.eventListener);
        } else {
            this.wrappedDriver = driver;
        }
    }

    public PageObjectAwareHtmlElementsLoader getHtmlElementsLoader(BasePageObject<?> pageObject) {
        return new PageObjectAwareHtmlElementsLoader(this.getActiveDriver(), pageObject);
    }

    public WebDriver open() {
        if (this.browserProvider == null) {
            this.browserProvider = Browser.getConfiguredBrowserProvider();
        }
        return this.open(this.browserProvider);
    }

    private WebDriver getActiveDriver() {
        return this.eventFiringDriver == null ? this.wrappedDriver : this.eventFiringDriver;
    }

    public WebDriver open(BrowserProvider config) {
        if (this.getActiveDriver() != null) {
            throw new RuntimeException("Browser is already open");
        }
        LOGGER.debug("Starting browser");
        this.browserProvider = config;
        this.wrappedDriver = config.createDriver();
        if (WebDriverConfig.getInstance().isEventLoggingEnabled()) {
            this.eventFiringDriver = new EventFiringWebDriver(this.wrappedDriver);
            this.eventListener = new SeleniumEventLogger();
            this.eventFiringDriver.register((WebDriverEventListener)this.eventListener);
        }
        this.sessionId = this.isRemoteDriver() ? ((RemoteWebDriver)this.getWrappedDriver()).getSessionId() : null;
        return this.getActiveDriver();
    }

    @Override
    public void close() {
        if (this.wrappedDriver == null) {
            return;
        }
        LOGGER.debug("Closing browser");
        this.removeScreenshotTaker();
        try {
            if (this.eventListener != null) {
                this.eventFiringDriver.unregister((WebDriverEventListener)this.eventListener);
            }
            this.getActiveDriver().quit();
        }
        catch (Exception ex) {
            LOGGER.warn("Exception attempting to quit the browser: " + ex.getMessage());
        }
        this.eventFiringDriver = null;
        this.wrappedDriver = null;
    }

    public BrowserProvider getBrowserProvider() {
        return this.browserProvider;
    }

    public static BrowserProvider getConfiguredBrowserProvider() {
        try {
            return (BrowserProvider)Class.forName(WebDriverConfig.getInstance().getBrowserProvider()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to create class " + WebDriverConfig.getInstance().getBrowserProvider(), e);
        }
    }

    public void registerScreenshotTaker() {
        if (!ReportLoggerFactory.hasScreenshotTaker()) {
            ScreenshotTaker screenshotTaker;
            try {
                screenshotTaker = this.getScreenshotTakerClass().getDeclaredConstructor(WebDriver.class).newInstance(this.wrappedDriver);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (e.getMessage() == null && e.getCause() != null) {
                    throw new RuntimeException(e.getCause());
                }
                throw new RuntimeException(e);
            }
            ReportLoggerFactory.setScreenshotTaker((ScreenshotTaker)screenshotTaker);
        }
    }

    public void removeScreenshotTaker() {
        ReportLoggerFactory.removeScreenshotTaker();
    }

    public static void setScreenshotTakerClass(Class<? extends ScreenshotTaker> screenshotTakerClass) {
        screenshotTaker = screenshotTakerClass;
    }

    public Class<? extends ScreenshotTaker> getScreenshotTakerClass() {
        return screenshotTaker;
    }
}

