/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class ChainExpectedConditions
implements ExpectedCondition<Boolean> {
    private List<Condition> conditions = new ArrayList<Condition>();

    public Boolean apply(WebDriver input) {
        for (Condition condition : this.conditions) {
            if (condition.passed) continue;
            Object result = condition.expected.apply((Object)input);
            if (result instanceof Boolean ? (Boolean)result == false : result == null) {
                return false;
            }
            condition.passed = true;
        }
        return true;
    }

    public ChainExpectedConditions and(ExpectedCondition<?> condition) {
        this.conditions.add(new Condition(condition));
        return this;
    }

    public static ChainExpectedConditions with(ExpectedCondition<?> condition) {
        ChainExpectedConditions c = new ChainExpectedConditions();
        return c.and(condition);
    }

    public String toString() {
        for (Condition condition : this.conditions) {
            if (condition.passed) continue;
            return condition.expected.toString();
        }
        return super.toString();
    }

    private static class Condition {
        private final ExpectedCondition<?> expected;
        private boolean passed = false;

        public Condition(ExpectedCondition<?> condition) {
            this.expected = condition;
        }
    }
}

