/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web;

import java.util.List;
import org.concordion.cubano.driver.web.PageHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class PageReadyConditions {
    private PageReadyConditions() {
    }

    public static final ExpectedCondition<Boolean> noActiveAjaxRequest() {
        return new ExpectedCondition<Boolean>(){
            private static final String SCRIPT = "if (typeof jQuery === 'undefined') return true;\nif (jQuery.active != 0) return false;\nreturn true;";

            public Boolean apply(WebDriver driver) {
                Boolean result;
                try {
                    result = (Boolean)((JavascriptExecutor)driver).executeScript(SCRIPT, new Object[0]);
                }
                catch (Exception ex) {
                    result = Boolean.FALSE;
                }
                return result;
            }

            public String toString() {
                return "no active Ajax requests";
            }
        };
    }

    public static final ExpectedCondition<Boolean> noVisibleSpinners() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                Boolean loaded = true;
                try {
                    List spinners = driver.findElements(By.className((String)"Spinner"));
                    for (WebElement spinner : spinners) {
                        if (!spinner.isDisplayed()) continue;
                        loaded = false;
                        break;
                    }
                }
                catch (Exception ex) {
                    loaded = false;
                }
                return loaded;
            }

            public String toString() {
                return "no spinner elements to be visible";
            }
        };
    }

    public static final ExpectedCondition<Boolean> switchToMainDocument() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                if (driver == null) {
                    return false;
                }
                PageHelper.switchToMainDocument(driver);
                return true;
            }

            public String toString() {
                return "unable to switch to main document";
            }
        };
    }
}

