/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.concordion.slf4j.ext.ReportLogger;
import org.concordion.slf4j.ext.ReportLoggerFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;

public class SeleniumEventLogger
extends AbstractWebDriverEventListener {
    private static final ReportLogger LOGGER = ReportLoggerFactory.getReportLogger(SeleniumEventLogger.class);
    private static final String FUNKY_ARROW = "&#8658;";
    private String originalValue;
    private By prevBy = null;
    private WebElement prevElement = null;
    private String prevScript = null;
    private String prevError = null;

    private String getElementName(WebElement element) {
        int arrowIndex;
        if (element == null) {
            return "";
        }
        String foundBy = element.toString();
        if (foundBy != null && (arrowIndex = foundBy.indexOf("->")) >= 0) {
            return "By." + foundBy.substring(arrowIndex + 3, foundBy.length() - 1).replace("->", FUNKY_ARROW);
        }
        return "unknown";
    }

    private String getBy(By by) {
        if (by == null) {
            return "";
        }
        return by.toString();
    }

    private String getParentLocation() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int foundIndex = -1;
        ArrayList<String> proxyNames = new ArrayList<String>();
        for (int i = 0; i < stack.length; ++i) {
            String className = stack[i].getClassName();
            if (className.startsWith("com.sun.proxy.$Proxy")) {
                proxyNames.add(className);
                foundIndex = i;
                continue;
            }
            if (!className.startsWith("org.openqa.selenium.support.")) continue;
            foundIndex = i;
        }
        if (foundIndex > 0) {
            String className = stack[foundIndex].getClassName();
            if (className.startsWith("com.sun.proxy.$Proxy") && proxyNames.stream().filter(s -> s.equals(className)).count() > 1L) {
                return null;
            }
            return className;
        }
        return null;
    }

    public void beforeNavigateTo(String url, WebDriver driver) {
        LOGGER.with().message("Navigating to {}", new Object[]{url}).htmlMessage("Navigating to {} <a class=\"greyed\" href=\"{}\">{}</a>", new Object[]{FUNKY_ARROW, url, url}).locationAwareParent(this.getParentLocation()).debug();
    }

    public void beforeNavigateBack(WebDriver driver) {
        LOGGER.with().htmlMessage("Navigating back from {} <span class=\"greyed\">{}</span>", new Object[]{FUNKY_ARROW, driver.getCurrentUrl()}).locationAwareParent(this.getParentLocation()).trace();
    }

    public void afterNavigateBack(WebDriver driver) {
        LOGGER.with().htmlMessage("Navigating back to {} <span class=\"greyed\">{}</span>", new Object[]{FUNKY_ARROW, driver.getCurrentUrl()}).locationAwareParent(this.getParentLocation()).trace();
    }

    public void beforeNavigateForward(WebDriver driver) {
        LOGGER.with().htmlMessage("Navigating forward from {} <span class=\"greyed\">{}</span>", new Object[]{FUNKY_ARROW, driver.getCurrentUrl()}).locationAwareParent(this.getParentLocation()).trace();
    }

    public void afterNavigateForward(WebDriver driver) {
        LOGGER.with().htmlMessage("Navigating forward to {} <span class=\"greyed\">{}</span>", new Object[]{FUNKY_ARROW, driver.getCurrentUrl()}).locationAwareParent(this.getParentLocation()).trace();
    }

    public void beforeFindBy(By by, WebElement element, WebDriver driver) {
        if (this.prevBy != null && this.prevBy.equals((Object)by) && (this.prevElement == null || this.prevElement.equals(element))) {
            return;
        }
        this.prevBy = by;
        this.prevElement = element;
        this.prevError = null;
        LOGGER.with().htmlMessage("Find element {} <span class=\"greyed\">{}{}{}</span>", new Object[]{FUNKY_ARROW, this.getBy(by), element == null ? "" : " in ", this.getElementName(element)}).locationAwareParent(this.getParentLocation()).trace();
        this.prevScript = null;
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        LOGGER.with().htmlMessage("Click {} <span class=\"greyed\">{}</span>", new Object[]{FUNKY_ARROW, this.getElementName(element)}).locationAwareParent(this.getParentLocation()).debug();
    }

    public void beforeChangeValueOf(WebElement element, WebDriver driver, CharSequence[] keysToSend) {
        this.originalValue = Arrays.toString(keysToSend);
        if (this.originalValue.isEmpty()) {
            this.originalValue = element.getAttribute("value");
        }
    }

    public void afterChangeValueOf(WebElement element, WebDriver driver, CharSequence[] keysToSend) {
        String changedValue = "";
        changedValue = Arrays.toString(keysToSend);
        String name = this.getElementName(element);
        LOGGER.with().htmlMessage("Change value {} <span class=\"greyed\">of {} from '{}' to '{}'</span>", new Object[]{FUNKY_ARROW, name, this.originalValue, changedValue}).locationAwareParent(this.getParentLocation()).debug();
    }

    public void beforeScript(String script, WebDriver driver) {
        String value;
        int pos = 80;
        if (script.length() < pos) {
            value = script;
        } else {
            Pattern p = Pattern.compile("[;\\r\\n]");
            Matcher m = p.matcher(script);
            if (m.find() && m.start() < pos) {
                pos = m.start();
            }
            value = script.substring(0, pos) + "...";
        }
        if (!value.equals(this.prevScript)) {
            this.prevScript = value;
            LOGGER.with().htmlMessage("Run JavaScript {}", new Object[]{FUNKY_ARROW}).data(script, new Object[0]).locationAwareParent(this.getParentLocation()).trace();
        }
    }

    public void onException(Throwable throwable, WebDriver driver) {
        if (this.prevError != null && this.prevError.equals(throwable.getClass().getName())) {
            return;
        }
        this.prevError = throwable.getClass().getName();
        LOGGER.with().htmlMessage("Selenium Error {} <span class=\"greyed\">{}</span>", new Object[]{FUNKY_ARROW, throwable.getMessage().replace("<", "&lt;").replace(">", "&gt;").replace("\r\n", "<br />").replace("\n", "<br />")}).locationAwareParent(this.getParentLocation()).trace();
    }
}

