/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.concordion.ext.ScreenshotTaker;
import org.concordion.ext.ScreenshotUnavailableException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumScreenshotTaker
implements ScreenshotTaker {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SeleniumScreenshotTaker.class);
    protected final WebDriver driver;
    protected final WebElement element;
    private static final String CHECK_IN_VIEWPORT = "var rect = arguments[0].getBoundingClientRect();return (rect.top >= 0 && rect.left >= 0 && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && /*or $(window).height() */ rect.right <= (window.innerWidth || document.documentElement.clientWidth) /*or $(window).width() */ )";

    public SeleniumScreenshotTaker(WebDriver driver) {
        this.driver = this.getBaseDriver(driver);
        this.element = null;
    }

    public SeleniumScreenshotTaker(WebDriver driver, WebElement element) {
        this.driver = this.getBaseDriver(driver);
        this.element = element;
    }

    private WebDriver getBaseDriver(WebDriver driver) {
        WebDriver baseDriver = driver;
        while (baseDriver instanceof EventFiringWebDriver) {
            baseDriver = ((EventFiringWebDriver)baseDriver).getWrappedDriver();
        }
        return baseDriver;
    }

    public Dimension writeScreenshotTo(OutputStream outputStream) throws IOException {
        String originalStyle = this.drawBorderAroundElement();
        Stack<WebElement> frames = this.cycleThroughFramesToTheParent();
        byte[] screenshot = this.takeScreenshot();
        this.cycleThroughFramesToTheChild(frames);
        outputStream.write(screenshot);
        this.removeBorderFromElement(originalStyle);
        return this.getImageDimension(screenshot);
    }

    protected byte[] takeScreenshot() {
        try {
            return (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
        }
        catch (ClassCastException e) {
            throw new ScreenshotUnavailableException("driver does not implement TakesScreenshot");
        }
    }

    private Stack<WebElement> cycleThroughFramesToTheParent() {
        WebElement frame;
        Stack<WebElement> frames = new Stack<WebElement>();
        while ((frame = (WebElement)((JavascriptExecutor)this.driver).executeScript("return window.frameElement", new Object[0])) != null) {
            frames.add(frame);
            this.driver.switchTo().parentFrame();
        }
        return frames;
    }

    private void cycleThroughFramesToTheChild(Stack<WebElement> frames) {
        while (frames.size() > 0) {
            this.driver.switchTo().frame(frames.pop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getImageDimension(byte[] screenshot) throws IOException {
        block17: {
            Throwable throwable = null;
            try (ImageInputStream in = ImageIO.createImageInputStream(new ByteArrayInputStream(screenshot));){
                Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                if (!readers.hasNext()) break block17;
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable2) {
                    try {
                        reader.dispose();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
        }
        throw new RuntimeException("Unable to read image dimensions");
    }

    public String getFileExtension() {
        return "png";
    }

    private String drawBorderAroundElement() {
        if (this.element == null) {
            return "";
        }
        String originalStyle = null;
        try {
            originalStyle = this.element.getAttribute("style");
            JavascriptExecutor executor = (JavascriptExecutor)this.driver;
            if (!((Boolean)executor.executeScript(CHECK_IN_VIEWPORT, new Object[]{this.element})).booleanValue()) {
                executor.executeScript("arguments[0].scrollIntoView(true);", new Object[]{this.element});
            }
            executor.executeScript("arguments[0].style.border='2px dashed red';", new Object[]{this.element});
        }
        catch (Exception e) {
            LOGGER.warn("Unable to set border style");
        }
        return originalStyle;
    }

    private void removeBorderFromElement(String originalStyle) {
        if (this.element == null) {
            return;
        }
        try {
            JavascriptExecutor executor = (JavascriptExecutor)this.driver;
            if (originalStyle == null || originalStyle.isEmpty()) {
                executor.executeScript("arguments[0].removeAttribute('style')", new Object[]{this.element});
            } else {
                executor.executeScript("arguments[0].style=arguments[1]", new Object[]{this.element, originalStyle});
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to remove border style");
        }
    }
}

