/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.config;

import java.util.Properties;
import org.concordion.cubano.config.Config;
import org.concordion.cubano.config.DefaultPropertyLoader;
import org.concordion.cubano.config.PropertiesLoader;
import org.concordion.cubano.config.PropertyLoader;

public final class WebDriverConfig {
    private final PropertyLoader propertyLoader;
    private String browserProvider;
    private String browserDimension;
    private String browserPosition;
    private boolean browserMaximized;
    private boolean eventLoggingEnabled;
    private boolean cleanupDriver;
    private String remoteUserName;
    private String remoteApiKey;
    private int restartBrowserAfterXTests;

    public static WebDriverConfig getInstance() {
        return WDCHolder.INSTANCE;
    }

    protected WebDriverConfig() {
        this.propertyLoader = Config.getInstance().getPropertyLoader();
        this.loadProperties();
    }

    protected WebDriverConfig(PropertiesLoader propertiesLoader) {
        this(propertiesLoader.getProperties());
    }

    protected WebDriverConfig(Properties properties) {
        this.propertyLoader = new DefaultPropertyLoader(properties);
        this.loadProperties();
    }

    public PropertyLoader getPropertyLoader() {
        return this.propertyLoader;
    }

    private void loadProperties() {
        this.browserProvider = System.getProperty("browserProvider");
        if (this.browserProvider == null) {
            this.browserProvider = this.propertyLoader.getProperty("webdriver.browserProvider", "FirefoxBrowserProvider");
        }
        if (!this.browserProvider.contains(".")) {
            this.browserProvider = "org.concordion.cubano.driver.web.provider." + this.browserProvider;
        }
        this.browserDimension = this.propertyLoader.getProperty("webdriver.browser.dimension", null);
        this.browserPosition = this.propertyLoader.getProperty("webdriver.browser.position", null);
        this.browserMaximized = this.propertyLoader.getPropertyAsBoolean("webdriver.browser.maximized", "false");
        this.eventLoggingEnabled = this.propertyLoader.getPropertyAsBoolean("webdriver.event.logging", "true");
        this.cleanupDriver = this.propertyLoader.getPropertyAsBoolean("webdriver.browserdriver.cleanup", "false");
        this.remoteUserName = this.propertyLoader.getProperty("remotewebdriver.userName", null);
        this.remoteApiKey = this.propertyLoader.getProperty("remotewebdriver.apiKey", null);
        System.setProperty("webdriver.timeouts.implicitlywait", this.propertyLoader.getProperty("webdriver.timeouts.implicitlywait", "0"));
        this.restartBrowserAfterXTests = this.propertyLoader.getPropertyAsInteger("webdriver.browser.restartAfterXTests", "0");
    }

    public String getBrowserProvider() {
        return this.browserProvider;
    }

    public String getBrowserPosition() {
        return this.browserPosition;
    }

    public String getBrowserDimension() {
        return this.browserDimension;
    }

    public int getRestartBrowserAfterXTests() {
        return this.restartBrowserAfterXTests;
    }

    public boolean isBrowserMaximized() {
        return this.browserMaximized;
    }

    public boolean isEventLoggingEnabled() {
        return this.eventLoggingEnabled;
    }

    public boolean isCleanupDriver() {
        return this.cleanupDriver;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public String getRemoteApiKey() {
        return this.remoteApiKey;
    }

    private static class WDCHolder {
        static final WebDriverConfig INSTANCE = new WebDriverConfig();

        private WDCHolder() {
        }
    }
}

