/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.dojo;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.concordion.cubano.driver.web.pagefactory.WebDriverAware;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;

public class DojoDropDownSelect
extends TypifiedElement
implements WebDriverAware {
    private WebElement inputElement = null;
    private WebDriver driver;
    private Duration pollingEvery = Duration.of(500L, ChronoUnit.MILLIS);
    private Duration timeout = Duration.of(10L, ChronoUnit.SECONDS);

    @Override
    public void setWebDriver(WebDriver driver) {
        this.driver = driver;
    }

    public DojoDropDownSelect(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public WebElement getInputElement() {
        if (this.inputElement == null) {
            WebElement element = super.getWrappedElement();
            this.inputElement = element.getAttribute("class").contains("dijitInputInner") ? element : element.findElement(By.xpath((String)".//input[contains(@class, 'dijitInputInner')]"));
        }
        return this.inputElement;
    }

    public String getText() {
        return this.getInputElement().getAttribute("value");
    }

    public void select(CharSequence charSequence) {
        this.select(charSequence, true);
    }

    public boolean selectReturningResult(CharSequence charSequence) {
        return this.select(charSequence, false);
    }

    public DojoDropDownSelect withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public DojoDropDownSelect withPollingEvery(Duration pollingEvery) {
        this.pollingEvery = pollingEvery;
        return this;
    }

    private boolean select(CharSequence charSequence, boolean throwsExceptionWhenNotFound) {
        this.getInputElement().clear();
        if (charSequence == null || charSequence.equals("")) {
            return false;
        }
        this.getInputElement().sendKeys(new CharSequence[]{charSequence});
        FluentWait wait = new FluentWait((Object)this.getWrappedElement()).pollingEvery(this.pollingEvery).withTimeout(this.timeout).ignoring(WebDriverException.class);
        String id = this.getInputElement().getAttribute("id");
        String resultSelector = "div.dijitComboBoxMenuPopup[dijitpopupparent='" + id + "'] .dijitMenuItem[item]";
        try {
            return (Boolean)wait.until(wrappedElement -> {
                String currentText = this.getText();
                if (currentText == null || currentText.equals("")) {
                    this.getInputElement().clear();
                    this.getInputElement().sendKeys(new CharSequence[]{charSequence});
                    return false;
                }
                List dropdownElements = this.driver.findElements(By.cssSelector((String)resultSelector));
                for (WebElement element : dropdownElements) {
                    String elementText;
                    if (!element.isDisplayed() || !(elementText = element.getText()).equals(charSequence)) continue;
                    element.click();
                    return true;
                }
                return false;
            });
        }
        catch (TimeoutException e) {
            if (throwsExceptionWhenNotFound) {
                throw new NoSuchElementException("Value '" + charSequence + "' was not found in the select list");
            }
            return false;
        }
    }
}

