/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.pagefactory.proxyhandlers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.concordion.cubano.driver.web.BasePageObject;
import org.concordion.cubano.driver.web.pagefactory.PageObjectAwareHtmlElementsLoader;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;

public class PageObjectAwareTypifiedElementListNamedProxyHandler<T extends TypifiedElement>
implements InvocationHandler {
    private final Class<T> elementClass;
    private final ElementLocator locator;
    private final String name;
    private final BasePageObject<?> parentPageObject;

    public PageObjectAwareTypifiedElementListNamedProxyHandler(Class<T> elementClass, ElementLocator locator, String name, BasePageObject<?> parentPageObject) {
        this.elementClass = elementClass;
        this.locator = locator;
        this.name = name;
        this.parentPageObject = parentPageObject;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if ("toString".equals(method.getName())) {
            return this.name;
        }
        LinkedList<T> elements = new LinkedList<T>();
        int elementNumber = 0;
        for (WebElement element : this.locator.findElements()) {
            String newName = String.format("%s [%d]", this.name, elementNumber++);
            elements.add(PageObjectAwareHtmlElementsLoader.createTypifiedElement(this.elementClass, element, newName, this.parentPageObject));
        }
        try {
            return method.invoke(elements, objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

