/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.provider;

import org.concordion.cubano.driver.web.config.WebDriverConfig;
import org.concordion.cubano.driver.web.provider.RemoteBrowserProvider;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SauceLabsBrowserProvider
extends RemoteBrowserProvider {
    private static final String REMOTE_URL = "http://[USER_NAME]:[API_KEY]@ondemand.saucelabs.com:80/wd/hub";
    private static final String TYPE = "application/json";

    public SauceLabsBrowserProvider() {
        String[] browserDetails;
        String browser = null;
        if (browser == null) {
            browser = "";
        }
        if ((browserDetails = browser.split(" ")).length <= 2) {
            String version = "";
            if (browserDetails.length == 2) {
                version = browserDetails[1];
            }
            switch (browserDetails[0]) {
                case "chrome": {
                    this.chrome(version);
                    break;
                }
                case "internetExplorer": 
                case "ie": {
                    this.internetExplorer(version);
                    break;
                }
                case "firefox": {
                    this.firefox(version);
                    break;
                }
                case "safari": {
                    this.safari(version);
                    break;
                }
            }
        }
        switch (browser) {
            case "iPhone6": {
                this.iPhone6();
                break;
            }
            case "iPhone6PlusEmulator": {
                this.iPhone6PlusEmulator();
                break;
            }
            case "samsungGalaxyS5": {
                this.samsungGalaxyS5();
                break;
            }
            case "samsungGalaxyS4Emulator": {
                this.samsungGalaxyS4Emulator();
                break;
            }
            case "googleNexus7CEmulator": {
                this.googleNexus7CEmulator();
                break;
            }
        }
        throw new RuntimeException("Browser '" + browser + "' is not currently supported");
    }

    @Override
    protected String getRemoteDriverUrl() {
        return REMOTE_URL.replace("[USER_NAME]", WebDriverConfig.getInstance().getRemoteUserName()).replace("[API_KEY]", WebDriverConfig.getInstance().getRemoteApiKey());
    }

    protected void desktop(DesiredCapabilities caps, String browserName, String browserVersion) {
        String platform = caps.getCapability("platformName").toString();
        caps.setCapability("version", browserVersion);
        caps.setCapability("screenResolution", "1024x768");
        caps.setCapability("name", String.format("%s %s, %s", browserName, browserVersion, platform));
        this.setDetails(browserName, "950x600", caps);
    }

    protected void desktop(DesiredCapabilities caps, String browserVersion) {
        String browserName = caps.getCapability("browserName").toString();
        this.desktop(caps, browserName, browserVersion);
    }

    protected void firefox(String browserVersion) {
        DesiredCapabilities caps = DesiredCapabilities.firefox();
        caps.setCapability("platform", "Windows 10");
        this.desktop(caps, browserVersion);
    }

    protected void chrome(String browserVersion) {
        DesiredCapabilities caps = DesiredCapabilities.chrome();
        caps.setCapability("platform", "Windows 10");
        this.desktop(caps, browserVersion);
    }

    protected void internetExplorer(String browserVersion) {
        DesiredCapabilities caps = DesiredCapabilities.internetExplorer();
        caps.setCapability("platform", "Windows 10");
        this.desktop(caps, "ie", browserVersion);
    }

    protected void safari(String browserVersion) {
        DesiredCapabilities caps = DesiredCapabilities.safari();
        caps.setCapability("platform", "OS X 10.11");
        this.desktop(caps, browserVersion);
    }

    protected void googleNexus7CEmulator() {
        DesiredCapabilities caps = DesiredCapabilities.android();
        caps.setCapability("deviceName", "Google Nexus 7C Emulator");
        caps.setCapability("deviceOrientation", "portrait");
        caps.setCapability("name", "Google Nexus 7C Emulator");
        this.setDetails("Google Nexus 7C Emulator", "?x?", caps);
    }

    protected void samsungGalaxyS4Emulator() {
        DesiredCapabilities caps = DesiredCapabilities.android();
        caps.setCapability("deviceName", "Samsung Galaxy S4 Emulator");
        caps.setCapability("deviceOrientation", "portrait");
        caps.setCapability("name", "Samsung Galaxy S4 Emulator");
        this.setDetails("Samsung Galaxy S4 Emulator", "?x?", caps);
    }

    protected void samsungGalaxyS5() {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("deviceName", "Samsung Galaxy S5 Device");
        caps.setCapability("platformName", "Android");
        caps.setCapability("platformVersion", "4.4");
        caps.setCapability("browserName", "Chrome");
        caps.setCapability("name", "Samsung Galaxy S5");
        this.setDetails("Samsung Galaxy S5", "?x?", caps);
    }

    protected void iPhone6PlusEmulator() {
        DesiredCapabilities caps = DesiredCapabilities.iphone();
        caps.setCapability("platform", "OS X 10.10");
        caps.setCapability("version", "9.2");
        caps.setCapability("deviceName", "iPhone 6 Plus");
        caps.setCapability("deviceOrientation", "portrait");
        caps.setCapability("name", "iPhone 6 Plus");
        this.setDetails("iPhone 6 Plus", "?x?", caps);
    }

    protected void iPhone6() {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("deviceName", "iPhone 6 Device");
        caps.setCapability("platformName", "iOS");
        caps.setCapability("platformVersion", "8.0");
        caps.setCapability("browserName", "Safari");
        caps.setCapability("name", "iPhone 6");
        this.setDetails("iPhone 6", "?x?", caps);
    }
}

