/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.spring;

import com.netflix.conductor.client.automator.TaskRunnerConfigurer;
import com.netflix.conductor.client.http.TaskClient;
import com.netflix.conductor.client.spring.ClientProperties;
import com.netflix.conductor.client.worker.Worker;
import com.netflix.conductor.sdk.workflow.executor.task.AnnotatedWorkerExecutor;
import com.netflix.discovery.EurekaClient;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ClientProperties.class})
public class ConductorClientAutoConfiguration {
    @Autowired(required=false)
    private EurekaClient eurekaClient;
    @Autowired(required=false)
    private List<Worker> workers = new ArrayList<Worker>();

    @ConditionalOnMissingBean
    @Bean
    public TaskClient taskClient(ClientProperties clientProperties) {
        TaskClient taskClient = new TaskClient();
        taskClient.setRootURI(clientProperties.getRootUri());
        return taskClient;
    }

    @ConditionalOnMissingBean
    @Bean
    public AnnotatedWorkerExecutor annotatedWorkerExecutor(TaskClient taskClient) {
        return new AnnotatedWorkerExecutor(taskClient);
    }

    @ConditionalOnMissingBean
    @Bean(initMethod="init", destroyMethod="shutdown")
    public TaskRunnerConfigurer taskRunnerConfigurer(TaskClient taskClient, ClientProperties clientProperties) {
        return new TaskRunnerConfigurer.Builder(taskClient, this.workers).withTaskThreadCount(clientProperties.getTaskThreadCount()).withThreadCount(clientProperties.getThreadCount()).withSleepWhenRetry((int)clientProperties.getSleepWhenRetryDuration().toMillis()).withUpdateRetryCount(clientProperties.getUpdateRetryCount()).withTaskToDomain(clientProperties.getTaskToDomain()).withShutdownGracePeriodSeconds(clientProperties.getShutdownGracePeriodSeconds()).withEurekaClient(this.eurekaClient).build();
    }
}

