/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.spring;

import com.netflix.conductor.client.http.TaskClient;
import com.netflix.conductor.client.spring.SpringWorkerConfiguration;
import com.netflix.conductor.sdk.workflow.executor.task.AnnotatedWorkerExecutor;
import com.netflix.conductor.sdk.workflow.executor.task.WorkerConfiguration;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ConductorWorkerAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private TaskClient taskClient;

    public void onApplicationEvent(ContextRefreshedEvent refreshedEvent) {
        ApplicationContext applicationContext = refreshedEvent.getApplicationContext();
        Environment environment = applicationContext.getEnvironment();
        SpringWorkerConfiguration configuration = new SpringWorkerConfiguration(environment);
        AnnotatedWorkerExecutor annotatedWorkerExecutor = new AnnotatedWorkerExecutor(this.taskClient, (WorkerConfiguration)configuration);
        Map beans = applicationContext.getBeansWithAnnotation(Component.class);
        beans.values().forEach(bean -> annotatedWorkerExecutor.addBean(bean));
        annotatedWorkerExecutor.startPolling();
    }
}

